/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.app.common;

import de.intarsys.security.smartcard.app.common.AbstractCardHolderApplication;
import de.intarsys.security.smartcard.app.common.AbstractCompositeCardHolderApplication;
import de.intarsys.security.smartcard.app.common.IAdvSignApplication;
import de.intarsys.security.smartcard.app.common.IQSignApplication;
import de.intarsys.security.smartcard.app.common.ISignApplication;
import de.intarsys.security.smartcard.card.ICardConnection;
import de.intarsys.security.smartcard.model.ICardApplication;
import de.intarsys.security.smartcard.model.ICardProduct;
import de.intarsys.security.smartcard.model.app.CardApplicationCardReset;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.security.smartcard.model.app.CardApplicationNotSupported;
import de.intarsys.security.smartcard.model.app.ICardHolderApplication;
import de.intarsys.tools.exception.InvalidRequestException;
import jakarta.annotation.PostConstruct;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Collection;
import java.util.HashSet;

public class CompositeSignApp
extends AbstractCompositeCardHolderApplication
implements IQSignApplication,
IAdvSignApplication {
    private IAdvSignApplication createAdvSignApp(ICardProduct product, ICardConnection connection) throws CardApplicationException {
        return product.createCardApplication(connection, IAdvSignApplication.class);
    }

    private IQSignApplication createQSignApp(ICardProduct product, ICardConnection connection) throws CardApplicationException {
        return product.createCardApplication(connection, IQSignApplication.class);
    }

    @Override
    public AlgorithmParameterSpec getAlgorithmParameterSpec() {
        if (this.getSelectedApplication() != null) {
            return ((ISignApplication)this.getSelectedApplication()).getAlgorithmParameterSpec();
        }
        return null;
    }

    @Override
    protected Class<? extends ICardApplication> getCardApplicationType() {
        return ISignApplication.class;
    }

    @Override
    public String getEncryptionAlgorithmName() {
        if (this.getSelectedApplication() != null) {
            return ((ISignApplication)this.getSelectedApplication()).getEncryptionAlgorithmName();
        }
        return "RSA";
    }

    @Override
    public String getHashAlgorithmName() {
        if (this.getSelectedApplication() != null) {
            return ((ISignApplication)this.getSelectedApplication()).getHashAlgorithmName();
        }
        return null;
    }

    @Override
    protected String getMsgPromptCodePrefix() {
        return "SignApp";
    }

    @Override
    public int getRestrictionCount() {
        if (this.getSelectedApplication() != null) {
            return ((ISignApplication)this.getSelectedApplication()).getRestrictionCount();
        }
        int count = -1;
        for (ICardHolderApplication app : this.getCardHolderApplications()) {
            if (((ISignApplication)app).getRestrictionCount() <= 0 || count != -1 && count <= ((ISignApplication)app).getRestrictionCount()) continue;
            count = ((ISignApplication)app).getRestrictionCount();
        }
        return count;
    }

    @Override
    public Collection<String> getSupportedEncryptionAlgorithmNames() {
        HashSet<String> algos = new HashSet<String>();
        algos.addAll(AbstractCardHolderApplication.ENCRYPTION_ALGORITHMS_ALL);
        for (ICardHolderApplication app : this.getCardHolderApplications()) {
            algos.retainAll(((ISignApplication)app).getSupportedEncryptionAlgorithmNames());
        }
        return algos;
    }

    @Override
    public Collection<String> getSupportedHashAlgorithmNames() {
        HashSet<String> algos = new HashSet<String>();
        algos.addAll(AbstractCardHolderApplication.DIGEST_ALGORITHMS_ALL);
        for (ICardHolderApplication app : this.getCardHolderApplications()) {
            algos.retainAll(((ISignApplication)app).getSupportedHashAlgorithmNames());
        }
        return algos;
    }

    @Override
    @PostConstruct
    public void initialize() throws CardApplicationException {
        CardApplicationException cae = null;
        IQSignApplication qSignApp = null;
        try {
            qSignApp = this.createQSignApp(this.getCardProduct(), this.getCardConnection());
            this.addCardHolderApplication(qSignApp);
        }
        catch (CardApplicationCardReset e) {
            throw e;
        }
        catch (CardApplicationException e) {
            cae = e;
        }
        IAdvSignApplication advSignApp = null;
        try {
            advSignApp = this.createAdvSignApp(this.getCardProduct(), this.getCardConnection());
            this.addCardHolderApplication(advSignApp);
        }
        catch (CardApplicationCardReset e) {
            throw e;
        }
        catch (CardApplicationException e) {
            CardApplicationException cardApplicationException = cae = cae == null ? e : cae;
        }
        if (qSignApp == null && advSignApp == null) {
            if (cae != null) {
                throw cae;
            }
            throw new CardApplicationNotSupported(ISignApplication.class);
        }
        super.initialize();
    }

    @Override
    public void setHashAlgorithmName(String name) throws CardApplicationException {
        if (this.getSelectedApplication() != null) {
            ((ISignApplication)this.getSelectedApplication()).setHashAlgorithmName(name);
        }
    }

    @Override
    public byte[] sign(byte[] data) throws CardApplicationException {
        if (this.getSelectedApplication() != null) {
            return ((ISignApplication)this.getSelectedApplication()).sign(data);
        }
        throw new InvalidRequestException("no application selected");
    }
}

