/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.app.common;

import de.intarsys.security.algorithm.ec.EcdsaTools;
import de.intarsys.security.encoding.PKCS1Type1Encoding;
import de.intarsys.security.smartcard.app.common.AbstractSignApp;
import de.intarsys.security.smartcard.app.common.IAdvSignApplication;
import de.intarsys.security.smartcard.model.ICardApplication;
import de.intarsys.security.smartcard.model.IMechanism;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.tools.digest.IDigest;
import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.security.PublicKey;
import org.bouncycastle.util.Arrays;

public class GenericAdvSignApp
extends AbstractSignApp
implements IAdvSignApplication {
    @Override
    protected byte[] basicSign(byte[] data) throws CardApplicationException {
        IMechanism mechanism = this.detectMechanism();
        if (mechanism == null) {
            throw new CardApplicationException("no mechanism found for " + this.getHashAlgorithmName());
        }
        this.cmdMseSetTemplate(mechanism, this.getCardHolderCertificate().getPrivateKeyInfo().getReference());
        String encryptionAlgorithmName = this.getEncryptionAlgorithmName();
        if ("RSA".equals(encryptionAlgorithmName)) {
            return this.basicSignRsa(data, mechanism);
        }
        if ("ECDSA".equals(encryptionAlgorithmName)) {
            return this.basicSignEcdsa(data, mechanism);
        }
        throw new CardApplicationException("encryption algorithm " + encryptionAlgorithmName + " not supported");
    }

    protected byte[] basicSignEcdsa(byte[] data, IMechanism mechanism) throws CardApplicationException {
        if ("DST".equals(mechanism.getOperation())) {
            return this.basicSignEcdsaDST(data, mechanism);
        }
        if ("AT".equals(mechanism.getOperation())) {
            return this.basicSignEcdsaAT(data, mechanism);
        }
        throw new CardApplicationException("mechanism " + mechanism.getOperation() + " not supported");
    }

    protected byte[] basicSignEcdsaAT(byte[] data, IMechanism mechanism) throws CardApplicationException {
        int size;
        IDigest digest = this.parseDigest(data);
        byte[] bytes = digest.getBytes();
        if (bytes.length > (size = this.getCardHolderCertificate().getKeyBitSize() / 8)) {
            bytes = Arrays.copyOf((byte[])bytes, (int)size);
        }
        byte[] signature = this.cmdInternalAuthenticate(bytes, 0).getData();
        return EcdsaTools.encodeDerSigValue((byte[])signature, (PublicKey)this.getCardHolderCertificate().getPublicKey());
    }

    protected byte[] basicSignEcdsaDST(byte[] data, IMechanism mechanism) throws CardApplicationException {
        int size;
        IDigest digest = this.parseDigest(data);
        byte[] bytes = digest.getBytes();
        if (bytes.length > (size = this.getCardHolderCertificate().getKeyBitSize() / 8)) {
            bytes = Arrays.copyOf((byte[])bytes, (int)size);
        }
        byte[] signature = this.cmdPsoComputeDigitalSignature(bytes).getData();
        return EcdsaTools.encodeDerSigValue((byte[])signature, (PublicKey)this.getCardHolderCertificate().getPublicKey());
    }

    protected byte[] basicSignRsa(byte[] data, IMechanism mechanism) throws CardApplicationException {
        if ("DST".equals(mechanism.getOperation())) {
            return this.basicSignRsaDST(data, mechanism);
        }
        if ("AT".equals(mechanism.getOperation())) {
            return this.basicSignRsaAT(data, mechanism);
        }
        if ("CT".equals(mechanism.getOperation())) {
            return this.basicSignRsaCT(data, mechanism);
        }
        throw new CardApplicationException("mechanism " + mechanism.getOperation() + " not supported");
    }

    protected byte[] basicSignRsaAT(byte[] data, IMechanism mechanism) throws CardApplicationException {
        int keySize = this.getCardHolderCertificate().getKeyBitSize() / 8;
        return this.cmdInternalAuthenticate(data, keySize).getData();
    }

    protected byte[] basicSignRsaCT(byte[] data, IMechanism mechanism) throws CardApplicationException {
        byte[] padded;
        PKCS1Type1Encoding encoding = new PKCS1Type1Encoding();
        encoding.setIntendedLengthBits(this.getCardHolderCertificate().getKeyBitSize());
        try {
            padded = encoding.encode(data);
        }
        catch (IOException e) {
            throw CardApplicationException.create(e);
        }
        return this.cmdPsoDecipher(padded, 0, 0).getData();
    }

    protected byte[] basicSignRsaDST(byte[] data, IMechanism mechanism) throws CardApplicationException {
        byte[] psoData = this.createPSOInput(data, mechanism);
        return this.cmdPsoComputeDigitalSignature(psoData).getData();
    }

    @Override
    protected Class<? extends ICardApplication> getCardApplicationType() {
        return IAdvSignApplication.class;
    }

    @Override
    protected String[] getMechanismPrecedence() {
        return new String[]{"DST", "AT", "CT"};
    }

    @Override
    @PostConstruct
    public void initialize() throws CardApplicationException {
        super.initialize();
        this.setRestrictionCount(this.getCardProduct().getGlobalRestriction(this.getCardConnection()));
    }
}

