/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.app.common;

import de.intarsys.security.algorithm.ec.EcdsaTools;
import de.intarsys.security.encoding.PKCS1Type1Encoding;
import de.intarsys.security.smartcard.app.common.AbstractAuthenticateApp;
import de.intarsys.security.smartcard.model.IMechanism;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import java.io.IOException;
import java.security.PublicKey;
import org.bouncycastle.util.Arrays;

public class GenericAuthenticateApp
extends AbstractAuthenticateApp {
    @Override
    protected byte[] basicSign(byte[] data) throws CardApplicationException {
        IMechanism mechanism = this.detectMechanism();
        if (mechanism == null) {
            throw new CardApplicationException("no mechanism found");
        }
        this.cmdMseSetTemplate(mechanism, this.getCardHolderCertificate().getPrivateKeyInfo().getReference());
        String encryptionAlgorithmName = this.getEncryptionAlgorithmName();
        if ("RSA".equals(encryptionAlgorithmName)) {
            return this.basicSignRsa(data, mechanism);
        }
        if ("ECDSA".equals(encryptionAlgorithmName)) {
            return this.basicSignEcdsa(data, mechanism);
        }
        throw new CardApplicationException("encryption algorithm " + encryptionAlgorithmName + " not supported");
    }

    protected byte[] basicSignEcdsa(byte[] data, IMechanism mechanism) throws CardApplicationException {
        if ("DST".equals(mechanism.getOperation())) {
            return this.basicSignEcdsaDST(data, mechanism);
        }
        if ("AT".equals(mechanism.getOperation())) {
            return this.basicSignEcdsaAT(data, mechanism);
        }
        throw new CardApplicationException("mechanism " + mechanism.getOperation() + " not supported");
    }

    protected byte[] basicSignEcdsaAT(byte[] data, IMechanism mechanism) throws CardApplicationException {
        int size = this.getCardHolderCertificate().getKeyBitSize() / 8;
        if (data.length > size) {
            data = Arrays.copyOf((byte[])data, (int)size);
        }
        byte[] signature = this.cmdInternalAuthenticate(data, 0).getData();
        return EcdsaTools.encodeDerSigValue((byte[])signature, (PublicKey)this.getCardHolderCertificate().getPublicKey());
    }

    protected byte[] basicSignEcdsaDST(byte[] data, IMechanism mechanism) throws CardApplicationException {
        int size = this.getCardHolderCertificate().getKeyBitSize() / 8;
        if (data.length > size) {
            data = Arrays.copyOf((byte[])data, (int)size);
        }
        byte[] signature = this.cmdPsoComputeDigitalSignature(data).getData();
        return EcdsaTools.encodeDerSigValue((byte[])signature, (PublicKey)this.getCardHolderCertificate().getPublicKey());
    }

    protected byte[] basicSignRsa(byte[] data, IMechanism mechanism) throws CardApplicationException {
        if ("DST".equals(mechanism.getOperation())) {
            return this.basicSignRsaDST(data, mechanism);
        }
        if ("AT".equals(mechanism.getOperation())) {
            return this.basicSignRsaAT(data, mechanism);
        }
        if ("CT".equals(mechanism.getOperation())) {
            return this.basigSignRsaCT(data, mechanism);
        }
        throw new CardApplicationException("mechanism " + mechanism.getOperation() + " not supported");
    }

    protected byte[] basicSignRsaAT(byte[] data, IMechanism mechanism) throws CardApplicationException {
        int keySize = this.getCardHolderCertificate().getKeyBitSize() / 8;
        return this.cmdInternalAuthenticate(data, keySize).getData();
    }

    protected byte[] basicSignRsaDST(byte[] data, IMechanism mechanism) throws CardApplicationException {
        return this.cmdPsoComputeDigitalSignature(data).getData();
    }

    protected byte[] basigSignRsaCT(byte[] data, IMechanism mechanism) throws CardApplicationException {
        byte[] padded;
        PKCS1Type1Encoding encoding = new PKCS1Type1Encoding();
        encoding.setIntendedLengthBits(this.getCardHolderCertificate().getKeyBitSize());
        try {
            padded = encoding.encode(data);
        }
        catch (IOException e) {
            throw CardApplicationException.create(e);
        }
        return this.cmdPsoDecipher(padded, 0, 0).getData();
    }

    @Override
    protected String[] getMechanismPrecedence() {
        return new String[]{"AT", "DST", "CT"};
    }
}

