/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.app.common;

import de.intarsys.security.algorithm.ec.EcTools;
import de.intarsys.security.smartcard.app.common.AbstractDecryptApp;
import de.intarsys.security.smartcard.model.IMechanism;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import java.security.spec.X509EncodedKeySpec;

public class GenericDecryptApp
extends AbstractDecryptApp {
    @Override
    protected byte[] basicDecrypt(byte[] data) throws CardApplicationException {
        IMechanism mechanism = this.detectMechanism();
        if (mechanism == null) {
            throw new CardApplicationException("no mechanism found");
        }
        this.cmdMseSetTemplate(mechanism, this.getCardHolderCertificate().getPrivateKeyInfo().getReference());
        String encryptionAlgorithmName = this.getEncryptionAlgorithmName();
        if ("RSA".equals(encryptionAlgorithmName)) {
            return this.basicDecryptRsa(data, mechanism);
        }
        if ("ECDSA".equals(encryptionAlgorithmName)) {
            return this.basicDecryptEcdsa(data, mechanism);
        }
        throw new CardApplicationException("encryption algorithm " + encryptionAlgorithmName + " not supported");
    }

    protected byte[] basicDecryptEcdsa(byte[] data, IMechanism mechanism) throws CardApplicationException {
        if ("CT".equals(mechanism.getOperation())) {
            return this.basicDecryptEcdsaCT(data, mechanism);
        }
        throw new CardApplicationException("mechanism " + mechanism.getOperation() + " not supported");
    }

    protected byte[] basicDecryptEcdsaCT(byte[] data, IMechanism mechanism) throws CardApplicationException {
        try {
            KeyFactory factory = KeyFactory.getInstance("EC", "BC");
            ECPublicKey publicKey = (ECPublicKey)factory.generatePublic(new X509EncodedKeySpec(data));
            EllipticCurve curve = publicKey.getParams().getCurve();
            byte[] uncompressedPoint = EcTools.encodeECPointX9Uncompressed((EllipticCurve)curve, (ECPoint)publicKey.getW());
            byte[] decryptedMessage = this.cmdPsoDecipher(uncompressedPoint, 0, 0).getData();
            return decryptedMessage;
        }
        catch (GeneralSecurityException e) {
            throw new CardApplicationException(e.getMessage());
        }
    }

    protected byte[] basicDecryptRsa(byte[] data, IMechanism mechanism) throws CardApplicationException {
        if ("DST".equals(mechanism.getOperation())) {
            this.basicDecryptRsaDST(mechanism);
        } else if ("AT".equals(mechanism.getOperation())) {
            this.basicDecryptRsaAT(mechanism);
        } else if ("CT".equals(mechanism.getOperation())) {
            return this.basicDecryptRsaCT(data, mechanism);
        }
        throw new CardApplicationException("mechanism " + mechanism.getOperation() + " not supported");
    }

    protected void basicDecryptRsaAT(IMechanism mechanism) throws CardApplicationException {
        throw new CardApplicationException("mechanism " + mechanism.getOperation() + " not supported");
    }

    protected byte[] basicDecryptRsaCT(byte[] data, IMechanism mechanism) throws CardApplicationException {
        byte[] decryptedMessage = this.cmdPsoDecipher(data, 0, 0).getData();
        return this.createPSOOutput(decryptedMessage, mechanism);
    }

    protected void basicDecryptRsaDST(IMechanism mechanism) throws CardApplicationException {
        throw new CardApplicationException("mechanism " + mechanism.getOperation() + " not supported");
    }

    @Override
    protected String[] getMechanismPrecedence() {
        return new String[]{"CT", "DST"};
    }
}

