/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.app.common;

import de.intarsys.security.algorithm.ec.EcdsaTools;
import de.intarsys.security.smartcard.app.common.AbstractSignApp;
import de.intarsys.security.smartcard.app.common.IQSignApplication;
import de.intarsys.security.smartcard.model.ICardApplication;
import de.intarsys.security.smartcard.model.IMechanism;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.tools.digest.IDigest;
import jakarta.annotation.PostConstruct;
import java.security.PublicKey;
import org.bouncycastle.util.Arrays;

public class GenericQSignApp
extends AbstractSignApp
implements IQSignApplication {
    @Override
    protected byte[] basicSign(byte[] data) throws CardApplicationException {
        IMechanism mechanism = this.detectMechanism();
        if (mechanism == null) {
            throw new CardApplicationException("no mechanism found for " + this.getHashAlgorithmName());
        }
        this.cmdMseSetTemplate(mechanism, this.getCardHolderCertificate().getPrivateKeyInfo().getReference());
        String encryptionAlgorithmName = this.getEncryptionAlgorithmName();
        if ("RSA".equals(encryptionAlgorithmName)) {
            return this.basicSignRsa(data, mechanism);
        }
        if ("ECDSA".equals(encryptionAlgorithmName)) {
            return this.basicSignEcdsa(data, mechanism);
        }
        throw new CardApplicationException("encryption algorithm " + encryptionAlgorithmName + " not supported");
    }

    protected byte[] basicSignEcdsa(byte[] data, IMechanism mechanism) throws CardApplicationException {
        if ("DST".equals(mechanism.getOperation())) {
            return this.basicSignEcdsaDST(data, mechanism);
        }
        throw new CardApplicationException("mechanism " + mechanism.getOperation() + " not supported");
    }

    protected byte[] basicSignEcdsaDST(byte[] data, IMechanism mechanism) throws CardApplicationException {
        int size;
        IDigest digest = this.parseDigest(data);
        byte[] bytes = digest.getBytes();
        if (bytes.length > (size = this.getCardHolderCertificate().getKeyBitSize() / 8)) {
            bytes = Arrays.copyOf((byte[])bytes, (int)size);
        }
        byte[] signature = this.cmdPsoComputeDigitalSignature(bytes).getData();
        return EcdsaTools.encodeDerSigValue((byte[])signature, (PublicKey)this.getCardHolderCertificate().getPublicKey());
    }

    protected byte[] basicSignRsa(byte[] data, IMechanism mechanism) throws CardApplicationException {
        if ("DST".equals(mechanism.getOperation())) {
            return this.basicSignRsaDST(data, mechanism);
        }
        throw new CardApplicationException("mechanism " + mechanism.getOperation() + " not supported");
    }

    protected byte[] basicSignRsaDST(byte[] data, IMechanism mechanism) throws CardApplicationException {
        byte[] psoData = this.createPSOInput(data, mechanism);
        return this.cmdPsoComputeDigitalSignature(psoData).getData();
    }

    @Override
    protected Class<? extends ICardApplication> getCardApplicationType() {
        return IQSignApplication.class;
    }

    @Override
    protected String[] getMechanismPrecedence() {
        return new String[]{"DST"};
    }

    @Override
    @PostConstruct
    public void initialize() throws CardApplicationException {
        super.initialize();
        this.setRestrictionCount(this.getCardProduct().getQSigRestriction(this.getCardConnection()));
    }
}

