/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.app.filesystem;

import de.intarsys.security.smartcard.app.filesystem.CardFileName;
import de.intarsys.security.smartcard.app.filesystem.CardFilePath;
import de.intarsys.security.smartcard.app.filesystem.CardFileSelector;
import de.intarsys.tools.hex.HexTools;
import java.util.Arrays;

public class CardFileId
extends CardFileSelector {
    public static final CardFileId MF = new CardFileId("3F00");
    public static final CardFileId CURRENT = new CardFileId("3FFF");
    private final byte[] file;

    public CardFileId(byte shortId) {
        this.file = new byte[1];
        this.file[0] = shortId;
    }

    public CardFileId(byte hi, byte low) {
        this.file = new byte[2];
        this.file[0] = hi;
        this.file[1] = low;
    }

    public CardFileId(byte[] bytes) {
        if (bytes == null || bytes.length > 2 || bytes.length < 1) {
            throw new IllegalArgumentException("a CardFile must be 1 or 2 bytes long");
        }
        this.file = (byte[])bytes.clone();
    }

    public CardFileId(int shortId) {
        this((byte)shortId);
    }

    public CardFileId(int hi, int low) {
        this((byte)hi, (byte)low);
    }

    public CardFileId(String symbolicFile) {
        this.file = HexTools.hexStringToBytes((String)symbolicFile);
    }

    public CardFileId copy() {
        return new CardFileId(this.file);
    }

    public boolean equals(Object obj) {
        if (obj instanceof CardFileId) {
            return Arrays.equals(this.file, ((CardFileId)obj).file);
        }
        return false;
    }

    public byte[] getBytes() {
        return (byte[])this.file.clone();
    }

    @Override
    public CardFileId getFileId() {
        return this;
    }

    @Override
    public CardFileName getFileName() {
        return null;
    }

    @Override
    public CardFilePath getFilePath() {
        return new CardFilePath(this);
    }

    public byte getHiByte() {
        return this.file[0];
    }

    public byte getLowByte() {
        return this.file[1];
    }

    @Override
    public CardFileSelector getParent() {
        return null;
    }

    public byte getShortId() {
        return this.file[0];
    }

    public int hashCode() {
        return Arrays.hashCode(this.file);
    }

    @Override
    public boolean isAbsolute() {
        return this.equals(MF);
    }

    public boolean isShort() {
        return this.file.length == 1;
    }

    @Override
    public CardFileSelector resolve(CardFileSelector selector) {
        if (selector == null) {
            return null;
        }
        if (selector.isAbsolute()) {
            return selector;
        }
        return new CardFilePath(this).append(selector.getFilePath());
    }

    public String toString() {
        return HexTools.bytesToHexString((byte[])this.file);
    }
}

