/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.app.filesystem;

import de.intarsys.security.smartcard.app.filesystem.CardFileId;
import de.intarsys.security.smartcard.app.filesystem.CardFilePath;
import de.intarsys.security.smartcard.app.filesystem.CardFileSelector;
import de.intarsys.security.smartcard.app.filesystem.CardNamedPath;
import de.intarsys.tools.hex.HexTools;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;

public class CardFileName
extends CardFileSelector {
    private final byte[] app;

    public CardFileName(byte[] aid) {
        Objects.requireNonNull(aid);
        if (aid.length == 0) {
            throw new IllegalArgumentException();
        }
        this.app = aid;
    }

    public CardFileName(String name) {
        Objects.requireNonNull(name);
        if (name.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.app = name.getBytes(StandardCharsets.ISO_8859_1);
    }

    public boolean equals(Object obj) {
        if (obj instanceof CardFileName) {
            CardFileName other = (CardFileName)obj;
            return Arrays.equals(this.app, other.app);
        }
        return false;
    }

    public byte[] getBytes() {
        return (byte[])this.app.clone();
    }

    @Override
    public CardFileId getFileId() {
        return null;
    }

    @Override
    public CardFileName getFileName() {
        return this;
    }

    @Override
    public CardFilePath getFilePath() {
        return new CardFilePath();
    }

    @Override
    public CardFileSelector getParent() {
        return null;
    }

    public int hashCode() {
        return Arrays.hashCode(this.app);
    }

    @Override
    public boolean isAbsolute() {
        return true;
    }

    @Override
    public CardFileSelector resolve(CardFileSelector selector) {
        if (selector == null) {
            return null;
        }
        if (selector.isAbsolute()) {
            return selector;
        }
        return new CardNamedPath(this, selector.getFilePath());
    }

    public String toString() {
        return HexTools.bytesToHexString((byte[])this.app);
    }
}

