/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.app.filesystem;

import de.intarsys.security.smartcard.app.filesystem.CardFileId;
import de.intarsys.security.smartcard.app.filesystem.CardFileName;
import de.intarsys.security.smartcard.app.filesystem.CardFileSelector;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CardFilePath
extends CardFileSelector
implements Iterable<CardFileId> {
    public static final CardFilePath ROOT = new CardFilePath(CardFileId.MF);
    private static final Pattern SplitPattern = Pattern.compile("([0-9a-fA-F]{4})");
    private final List<CardFileId> path;

    public CardFilePath() {
        this.path = new ArrayList<CardFileId>(1);
    }

    public CardFilePath(byte[] bytes) {
        Objects.requireNonNull(bytes);
        this.path = new ArrayList<CardFileId>((bytes.length + 1) / 2);
        if (bytes.length == 0) {
            this.path.add(CardFileId.MF);
        }
        for (int i = 0; i < bytes.length; i += 2) {
            if (bytes.length - i == 1) {
                this.path.add(new CardFileId(bytes[i]));
                continue;
            }
            this.path.add(new CardFileId(bytes[i], bytes[i + 1]));
        }
    }

    public CardFilePath(CardFileId pathItem) {
        this.path = new ArrayList<CardFileId>(1);
        this.path.add(pathItem);
    }

    public CardFilePath(CardFileId id1, CardFileId id2) {
        this.path = new ArrayList<CardFileId>(2);
        this.path.add(id1);
        this.path.add(id2);
    }

    protected CardFilePath(List<CardFileId> path) {
        this.path = path;
    }

    public CardFilePath(String symbolicPath) {
        Matcher m = SplitPattern.matcher(symbolicPath);
        this.path = new ArrayList<CardFileId>(4);
        while (m.find()) {
            this.path.add(new CardFileId(m.group()));
        }
        if (this.path.isEmpty()) {
            throw new IllegalArgumentException("illegal path item count");
        }
    }

    public CardFilePath append(CardFileId pathItem) {
        List<CardFileId> clone = this.getFileIds();
        if (pathItem != null) {
            clone.add(pathItem);
        }
        return new CardFilePath(clone);
    }

    public CardFilePath append(CardFilePath path) {
        List<CardFileId> clone = this.getFileIds();
        clone.addAll(path.getFileIds());
        return new CardFilePath(clone);
    }

    public boolean equals(Object obj) {
        if (obj instanceof CardFilePath) {
            CardFilePath otherPath = (CardFilePath)obj;
            if (otherPath.size() != this.size()) {
                return false;
            }
            List<CardFileId> other = otherPath.getFileIds();
            for (int i = 0; i < this.size(); ++i) {
                if (this.path.get(i).equals(other.get(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public byte[] getBytes() {
        byte[] bytes = new byte[this.size() * 2];
        for (int i = 0; i < this.path.size(); ++i) {
            byte[] temp = this.path.get(i).getBytes();
            bytes[i * 2] = temp[0];
            bytes[i * 2 + 1] = temp[1];
        }
        return bytes;
    }

    @Override
    public CardFileId getFileId() {
        return this.path.get(this.size() - 1);
    }

    public List<CardFileId> getFileIds() {
        return new ArrayList<CardFileId>(this.path);
    }

    @Override
    public CardFileName getFileName() {
        return null;
    }

    @Override
    public CardFilePath getFilePath() {
        return this;
    }

    @Override
    public CardFilePath getParent() {
        List<CardFileId> clone = this.getFileIds();
        clone.remove(clone.size() - 1);
        return new CardFilePath(clone);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public boolean isAbsolute() {
        return this.startsWith(ROOT);
    }

    @Override
    public Iterator<CardFileId> iterator() {
        return this.path.iterator();
    }

    @Override
    public CardFileSelector resolve(CardFileSelector selector) {
        if (selector == null) {
            return null;
        }
        if (selector.isAbsolute()) {
            return selector;
        }
        List<CardFileId> clone = this.getFileIds();
        clone.addAll(selector.getFilePath().getFileIds());
        return new CardFilePath(clone);
    }

    public int size() {
        return this.path.size();
    }

    public boolean startsWith(CardFilePath otherPath) {
        if (otherPath.size() > this.size()) {
            return false;
        }
        List<CardFileId> other = otherPath.getFileIds();
        for (int i = 0; i < other.size(); ++i) {
            if (this.path.get(i).equals(other.get(i))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (CardFileId file : this.path) {
            if (sb.length() != 0) {
                sb.append(":");
            }
            sb.append(file);
        }
        return sb.toString();
    }
}

