/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.app.filesystem;

import de.intarsys.security.smartcard.app.filesystem.CardFileId;
import de.intarsys.security.smartcard.app.filesystem.CardFileName;
import de.intarsys.security.smartcard.app.filesystem.CardFilePath;
import de.intarsys.security.smartcard.app.filesystem.CardFileSelector;

public class CardNamedPath
extends CardFileSelector {
    private final CardFileName root;
    private final CardFilePath path;

    public CardNamedPath(CardFileName root, CardFilePath path) {
        if (root == null) {
            throw new NullPointerException("root missing");
        }
        this.root = root;
        this.path = path;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CardNamedPath) {
            CardNamedPath otherPath = (CardNamedPath)obj;
            return this.root.equals(otherPath.getRoot()) && this.path.equals(otherPath.getFilePath());
        }
        return false;
    }

    @Override
    public CardFileId getFileId() {
        return this.getFilePath().getFileId();
    }

    @Override
    public CardFileName getFileName() {
        return this.getRoot();
    }

    @Override
    public CardFilePath getFilePath() {
        return this.path;
    }

    @Override
    public CardFileSelector getParent() {
        return new CardNamedPath(this.root, this.path.getParent());
    }

    public CardFileName getRoot() {
        return this.root;
    }

    public int hashCode() {
        return this.root.hashCode() + this.path.hashCode();
    }

    @Override
    public boolean isAbsolute() {
        return true;
    }

    @Override
    public CardFileSelector resolve(CardFileSelector selector) {
        if (selector == null) {
            return null;
        }
        if (selector.isAbsolute()) {
            return selector;
        }
        return new CardNamedPath(this.root, this.path.append(selector.getFilePath()));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.root.toString());
        sb.append(":");
        sb.append(this.path.toString());
        return sb.toString();
    }
}

