/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.app.filesystem;

import de.intarsys.security.smartcard.app.filesystem.CardFileId;
import de.intarsys.security.smartcard.app.filesystem.CardFileInfo;
import de.intarsys.security.smartcard.iso.dataobject.FCP;
import de.intarsys.security.smartcard.iso.dataobject.FileDescriptor;
import de.intarsys.security.smartcard.iso.dataobject.FileID;
import de.intarsys.security.smartcard.iso.dataobject.SizeExcludingStructure;
import de.intarsys.security.smartcard.iso.dataobject.SizeIncludingStructure;
import de.intarsys.tools.tlv.common.TlvElement;

public class FCPbasedFileInfo
implements CardFileInfo {
    private FCP fcp;

    public FCPbasedFileInfo(FCP fcp) {
        this.fcp = fcp;
    }

    @Override
    public CardFileId getCardFile() {
        FileID fileID = this.fcp.getFileID();
        if (fileID != null) {
            return fileID.asCardFile();
        }
        return null;
    }

    @Override
    public TlvElement getElement() {
        return this.fcp.getElement();
    }

    public FCP getFCP() {
        return this.fcp;
    }

    public int getFileID() {
        FileID id = this.fcp.getFileID();
        if (id != null) {
            return id.asInt();
        }
        return 0;
    }

    @Override
    public int getLength() {
        SizeExcludingStructure ex = this.fcp.getSizeExcludingStructure();
        if (ex != null) {
            return ex.getSize();
        }
        SizeIncludingStructure inc = this.fcp.getSizeIncludingStructure();
        if (inc != null) {
            return inc.getSize();
        }
        return 0;
    }

    @Override
    public int getNumberOfRecords() {
        FileDescriptor fd = this.fcp.getFileDescriptor();
        if (fd != null) {
            return fd.getNumberOfRecords();
        }
        return 0;
    }

    @Override
    public int getRecordSize() {
        FileDescriptor fd = this.fcp.getFileDescriptor();
        if (fd != null) {
            return fd.getMaximumRecordSize();
        }
        return 0;
    }

    @Override
    public boolean isCyclic() {
        FileDescriptor fd = this.fcp.getFileDescriptor();
        if (fd != null) {
            return fd.isCyclicFixed();
        }
        return false;
    }

    @Override
    public boolean isDirectory() {
        FileDescriptor fd = this.fcp.getFileDescriptor();
        if (fd != null) {
            return fd.isDirectory();
        }
        return false;
    }

    @Override
    public boolean isTlv() {
        FileDescriptor fd = this.fcp.getFileDescriptor();
        if (fd != null) {
            return fd.isTlv();
        }
        return false;
    }

    @Override
    public boolean isTransparent() {
        FileDescriptor fd = this.fcp.getFileDescriptor();
        if (fd != null) {
            return fd.isTransparent();
        }
        return false;
    }

    @Override
    public boolean isVariable() {
        FileDescriptor fd = this.fcp.getFileDescriptor();
        if (fd != null) {
            return fd.isLinearVariable();
        }
        return false;
    }
}

