/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.app.filesystem;

import de.intarsys.security.smartcard.app.filesystem.CardFileInfo;
import de.intarsys.security.smartcard.app.filesystem.CardFileSelector;
import de.intarsys.security.smartcard.app.filesystem.IFileSystemApplication;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import java.io.IOException;
import java.io.InputStream;

public class FileInputStream
extends InputStream {
    protected static final int BUFFER_LENGTH = 512;
    private final CardFileSelector path;
    private final CardFileInfo info;
    private final int length;
    private byte[] buffer;
    private int bufferLength;
    private int index;
    private int fileOffset;
    private int mark;
    private boolean eof = false;
    private final IFileSystemApplication fileSystem;

    public FileInputStream(IFileSystemApplication fileSystem, CardFileSelector path) throws CardApplicationException {
        this.fileSystem = fileSystem;
        this.path = path;
        this.info = fileSystem.selectEf(path, true);
        this.length = this.info != null ? this.info.getLength() : -1;
        this.fileOffset = 0;
        this.index = 0;
        this.bufferLength = 0;
    }

    protected void fillBuffer() throws IOException {
        this.fileOffset += this.index;
        this.index = 0;
        if (this.length != -1 && this.fileOffset >= this.length) {
            this.eof = true;
            return;
        }
        try {
            this.buffer = this.fileSystem.readBinary(this.path, this.fileOffset, 512);
            if (this.buffer == null) {
                this.eof = true;
                return;
            }
            this.bufferLength = this.buffer.length;
        }
        catch (CardApplicationException e) {
            throw new IOException(e.getLocalizedMessage(), e);
        }
    }

    protected CardFileInfo getInfo() {
        return this.info;
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.mark = this.fileOffset + this.index;
    }

    @Override
    public int read() throws IOException {
        if (this.eof) {
            return -1;
        }
        if (this.index >= this.bufferLength) {
            this.fillBuffer();
            if (this.eof) {
                return -1;
            }
        }
        return this.buffer[this.index++] & 0xFF;
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this.fileOffset <= this.mark && this.mark < this.fileOffset + this.buffer.length) {
            this.index = this.mark - this.fileOffset;
            return;
        }
        this.fileOffset = this.mark;
        this.index = 0;
        this.fillBuffer();
    }
}

