/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.app.filesystem;

import de.intarsys.security.smartcard.app.filesystem.CardFileInfo;
import de.intarsys.security.smartcard.app.filesystem.CardFileNotFoundException;
import de.intarsys.security.smartcard.app.filesystem.CardFilePath;
import de.intarsys.security.smartcard.app.filesystem.IFileSystemApplication;
import de.intarsys.security.smartcard.card.ICardConnection;
import de.intarsys.security.smartcard.iso.tlv.Iso7816BerInputStream;
import de.intarsys.security.smartcard.iso.tlv.Iso7816SimpleInputStream;
import de.intarsys.security.smartcard.model.ICardFile;
import de.intarsys.security.smartcard.model.ICardFileSystem;
import de.intarsys.security.smartcard.model.ICardProduct;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.tools.hex.HexTools;
import de.intarsys.tools.stream.StreamTools;
import de.intarsys.tools.tlv.common.TlvElement;
import java.io.Closeable;
import java.io.IOException;

public class FileSystemExplorer {
    protected void dump(ICardProduct product, ICardConnection connection, ICardFile file) throws CardApplicationException {
        try {
            if (file.isDirectory()) {
                this.dumpDirectory(product, connection, file);
            } else {
                try {
                    this.dumpFile(product, connection, file);
                }
                catch (Exception exception) {}
            }
        }
        catch (CardFileNotFoundException e) {
            this.write(file.getLabel() + " : " + file.getFileId());
            this.write(e.getLocalizedMessage());
            this.write("");
        }
    }

    public void dump(ICardProduct product, ICardConnection connection, ICardFileSystem filesystem) throws CardApplicationException {
        for (ICardFile child : filesystem.getRoot().getFiles()) {
            this.dump(product, connection, child);
        }
    }

    protected void dumpDirectory(ICardProduct product, ICardConnection connection, ICardFile file) throws CardApplicationException {
        for (ICardFile child : file.getFiles()) {
            this.dump(product, connection, child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dumpFile(ICardProduct product, ICardConnection connection, ICardFile file) throws CardApplicationException {
        block15: {
            IFileSystemApplication fileSystem = product.createCardApplication(connection, IFileSystemApplication.class);
            this.write(file.getLabel() + " : " + file.getFileId());
            CardFileInfo info = fileSystem.selectEf(new CardFilePath(file.getFileId()), true);
            try {
                if (info.isTransparent()) {
                    CardFilePath path = new CardFilePath(file.getFileId());
                    byte[] data = fileSystem.readBinary(path);
                    if ("ber".equals(file.getContent())) {
                        Iso7816BerInputStream is = null;
                        try {
                            is = new Iso7816BerInputStream(data, 0, data.length);
                            TlvElement element = is.readElement();
                            data = element.getValue();
                            this.write("0x" + Integer.toHexString(element.getIdentifier()) + " - " + HexTools.bytesToHexString((byte[])data, (int)0, (int)data.length, (boolean)true));
                        }
                        catch (IOException e) {
                            try {
                                this.write("...decoding failed (" + e.getMessage() + ")");
                                this.write(HexTools.bytesToHexString((byte[])data, (int)0, (int)data.length, (boolean)true));
                            }
                            catch (Throwable throwable) {
                                StreamTools.close(is);
                                throw throwable;
                            }
                            StreamTools.close((Closeable)((Object)is));
                            break block15;
                        }
                        StreamTools.close((Closeable)((Object)is));
                        break block15;
                    }
                    if ("simple".equals(file.getContent())) {
                        Iso7816SimpleInputStream is = null;
                        try {
                            is = new Iso7816SimpleInputStream(data, 0, data.length);
                            TlvElement element = is.readElement();
                            data = element.getValue();
                            this.write("0x" + Integer.toHexString(element.getIdentifier()) + " - " + HexTools.bytesToHexString((byte[])data, (int)0, (int)data.length, (boolean)true));
                        }
                        catch (IOException e) {
                            try {
                                this.write("...decoding failed (" + e.getMessage() + ")");
                                this.write(HexTools.bytesToHexString((byte[])data, (int)0, (int)data.length, (boolean)true));
                            }
                            catch (Throwable throwable) {
                                StreamTools.close(is);
                                throw throwable;
                            }
                            StreamTools.close((Closeable)((Object)is));
                            break block15;
                        }
                        StreamTools.close((Closeable)((Object)is));
                        break block15;
                    }
                    this.write(HexTools.bytesToHexString((byte[])data, (int)0, (int)data.length, (boolean)true));
                    break block15;
                }
                CardFilePath path = new CardFilePath(file.getFileId());
                int index = 1;
                byte[] data = fileSystem.readRecord(path, index);
                while (data != null) {
                    this.write(HexTools.bytesToHexString((byte[])data, (int)0, (int)data.length, (boolean)true));
                    data = fileSystem.readRecord(path, ++index);
                }
            }
            finally {
                this.write("");
            }
        }
    }

    protected void write(String value) {
    }
}

