/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.app.filesystem;

import de.intarsys.security.smartcard.app.filesystem.AbstractFileSystemApp;
import de.intarsys.security.smartcard.app.filesystem.CardFileId;
import de.intarsys.security.smartcard.app.filesystem.CardFileInfo;
import de.intarsys.security.smartcard.app.filesystem.CardFileName;
import de.intarsys.security.smartcard.app.filesystem.CardFilePath;
import de.intarsys.security.smartcard.app.filesystem.CardFileSelector;
import de.intarsys.security.smartcard.app.filesystem.CardFileTools;
import de.intarsys.security.smartcard.card.RequestAPDU;
import de.intarsys.security.smartcard.card.ResponseAPDU;
import de.intarsys.security.smartcard.iso.tlv.Iso7816SimpleElement;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.security.smartcard.model.app.CardStatusCodeException;
import de.intarsys.security.smartcard.model.cmd.ICmdAppendRecord;
import de.intarsys.security.smartcard.model.cmd.ICmdReadBinary;
import de.intarsys.security.smartcard.model.cmd.ICmdReadRecord;
import de.intarsys.security.smartcard.model.cmd.ICmdSelect;
import de.intarsys.security.smartcard.model.cmd.ICmdUpdateBinary;
import de.intarsys.security.smartcard.model.cmd.ICmdUpdateRecord;
import de.intarsys.tools.attribute.Attribute;
import de.intarsys.tools.collection.ByteArrayTools;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class GenericFileSystemApp
extends AbstractFileSystemApp {
    private static final Attribute ATTR_FILES = new Attribute("files");
    private static final Attribute ATTR_RECORDS = new Attribute("records");
    private boolean supportsSelectParent = true;

    @Override
    public void appendRecord(CardFileSelector file, byte[] bytes) throws CardApplicationException {
        this.selectEf(file, false);
        ICmdAppendRecord cmd = this.getCommand(ICmdAppendRecord.class);
        RequestAPDU req = cmd.create(bytes);
        this.sendRequest(cmd, req);
    }

    private byte[] getCachedFile(CardFileSelector absolutePath) {
        return this.getCachedFiles().get(absolutePath);
    }

    private Map<CardFileSelector, byte[]> getCachedFiles() {
        HashMap tempMap = (HashMap)this.getCardConnection().getCard().getAttribute((Object)ATTR_FILES);
        if (tempMap == null) {
            tempMap = new HashMap();
            this.getCardConnection().getCard().setAttribute((Object)ATTR_FILES, tempMap);
        }
        return tempMap;
    }

    private byte[] getCachedRecord(CardFileSelector absolutePath, int index) {
        return this.getCachedRecords(absolutePath).get(index);
    }

    private Map<Integer, byte[]> getCachedRecords(CardFileSelector absolutePath) {
        HashMap<CardFileSelector, Map> tempMap = (HashMap<CardFileSelector, Map>)this.getCardConnection().getCard().getAttribute((Object)ATTR_RECORDS);
        if (tempMap == null) {
            tempMap = new HashMap<CardFileSelector, Map>();
            this.getCardConnection().getCard().setAttribute((Object)ATTR_RECORDS, tempMap);
        }
        return tempMap.computeIfAbsent(absolutePath, key -> new HashMap());
    }

    @Override
    public boolean isSelected(CardFileSelector path) {
        if (path.equals(this.getCurrentDf())) {
            return true;
        }
        return path.equals(this.getCurrentEf());
    }

    public boolean isSupportsSelectParent() {
        return this.supportsSelectParent;
    }

    @Override
    public byte[] readBinary(CardFileSelector file) throws CardApplicationException {
        CardFileInfo info = this.selectEf(file, true);
        if (info != null) {
            byte[] result = new byte[info.getLength()];
            int count = this.readBinaryAll(file, result);
            if (count == result.length) {
                return result;
            }
            return ByteArrayTools.copy((byte[])result, (int)0, (int)count);
        }
        ICmdReadBinary cmdRead = this.getCommand(ICmdReadBinary.class);
        RequestAPDU req = cmdRead.create(file.getFileId(), 0, 0);
        ResponseAPDU resp = this.sendRequest(cmdRead, req);
        return resp.getData();
    }

    @Override
    public int readBinary(CardFileSelector file, int fileOffset, byte[] bytes, int byteOffset, int length) throws CardApplicationException {
        int read;
        block2: {
            this.selectEf(file, false);
            int tmpLength = length > 255 ? 0 : length;
            ICmdReadBinary cmdRead = this.getCommand(ICmdReadBinary.class);
            RequestAPDU req = cmdRead.create(file.getFileId(), fileOffset, tmpLength);
            read = 0;
            try {
                ResponseAPDU resp = this.sendRequest(cmdRead, req);
                read = resp.getData(bytes, byteOffset, length);
            }
            catch (CardStatusCodeException e) {
                if (e.getSw1() == 107 && e.getSw2() == 0) break block2;
                throw e;
            }
        }
        return read;
    }

    @Override
    public byte[] readBinary(CardFileSelector file, int fileOffset, int length) throws CardApplicationException {
        this.selectEf(file, false);
        int tmpLength = length > 255 ? 0 : length;
        ICmdReadBinary cmdRead = this.getCommand(ICmdReadBinary.class);
        RequestAPDU req = cmdRead.create(file.getFileId(), fileOffset, tmpLength);
        try {
            ResponseAPDU resp = this.sendRequest(cmdRead, req);
            return resp.getData();
        }
        catch (CardStatusCodeException e) {
            if (e.getSw1() == 107 && e.getSw2() == 0) {
                return null;
            }
            throw e;
        }
    }

    protected int readBinaryAll(CardFileSelector file, byte[] bytes) throws CardApplicationException {
        int read;
        int count;
        for (read = 0; read < bytes.length && (count = this.readBinary(file, read, bytes, read, bytes.length - read)) != 0; read += count) {
        }
        return read;
    }

    @Override
    public byte[] readBinaryCached(CardFileSelector file) throws CardApplicationException {
        CardFileSelector absolutePath = this.getCurrentDf().resolve(file);
        byte[] result = this.getCachedFile(absolutePath);
        if (result == null) {
            result = this.readBinary(file);
            this.setCachedFile(absolutePath, result);
        }
        return result;
    }

    @Override
    public byte[] readRecord(CardFileSelector file, int index) throws CardApplicationException {
        int recordSize = 0;
        CardFileInfo fileInfo = this.selectEf(file, true);
        if (fileInfo != null) {
            recordSize = fileInfo.getRecordSize();
        }
        ICmdReadRecord cmdRead = this.getCommand(ICmdReadRecord.class);
        RequestAPDU req = cmdRead.create(file.getFileId(), index, recordSize);
        ResponseAPDU resp = this.sendRequest(cmdRead, req);
        byte[] data = resp.getData();
        if (fileInfo == null || fileInfo.isTlv()) {
            try {
                Iso7816SimpleElement element = Iso7816SimpleElement.parseElement(data, 0, data.length);
                if (element != null) {
                    data = element.getValue();
                }
            }
            catch (IOException e) {
                throw CardApplicationException.create(e);
            }
        }
        return data;
    }

    @Override
    public byte[] readRecordCached(CardFileSelector file, int index) throws CardApplicationException {
        CardFileSelector absolutePath = this.getCurrentDf().resolve(file);
        byte[] result = this.getCachedRecord(absolutePath, index);
        if (result == null) {
            result = this.readRecord(file, index);
            this.setCachedRecord(absolutePath, index, result);
        }
        return result;
    }

    @Override
    public byte[][] readRecords(CardFileSelector file, int count) throws CardApplicationException {
        CardFileInfo fileInfo = this.selectEf(file, true);
        if (fileInfo == null) {
            throw new CardApplicationException("cannot read file '" + file + "' due to missing file info");
        }
        int numRec = fileInfo.getNumberOfRecords();
        int recSize = fileInfo.getRecordSize();
        if (numRec <= 0 && recSize != 0 && !fileInfo.isVariable() && fileInfo.getLength() > 0) {
            numRec = fileInfo.getLength() / recSize;
        }
        if (count >= 0 && (count < numRec || numRec <= 0)) {
            numRec = count;
        }
        ArrayList<byte[]> records = new ArrayList<byte[]>(numRec);
        for (int i = 0; i < numRec; ++i) {
            ICmdReadRecord cmdRead = this.getCommand(ICmdReadRecord.class);
            RequestAPDU req = cmdRead.create(file.getFileId(), i + 1, recSize);
            try {
                ResponseAPDU resp = this.sendRequest(cmdRead, req);
                byte[] data = resp.getData();
                if (fileInfo.isTlv()) {
                    try {
                        Iso7816SimpleElement element = Iso7816SimpleElement.parseElement(data, 0, data.length);
                        data = element.getValue();
                    }
                    catch (IOException e) {
                        throw CardApplicationException.create(e);
                    }
                }
                records.add(data);
                continue;
            }
            catch (CardStatusCodeException e) {
                if (e.getSw() == 27267) break;
                throw e;
            }
        }
        return (byte[][])records.toArray((T[])new byte[records.size()][]);
    }

    @Override
    public byte[][] readRecordsCached(CardFileSelector file, int count) throws CardApplicationException {
        ArrayList<byte[]> records;
        block5: {
            int numRecords = count;
            CardFileInfo fileInfo = this.selectEf(file, true);
            if (fileInfo != null) {
                numRecords = fileInfo.getNumberOfRecords();
                if (count > 0 && count < numRecords) {
                    numRecords = count;
                }
            }
            records = new ArrayList<byte[]>();
            try {
                for (int i = 0; i < numRecords; ++i) {
                    records.add(this.readRecordCached(file, i + 1));
                }
            }
            catch (CardStatusCodeException e) {
                if (e.getSw() == 27267) break block5;
                throw e;
            }
        }
        return (byte[][])records.toArray((T[])new byte[records.size()][]);
    }

    protected CardFileInfo selectChildDf(CardFileId targetFile, boolean readFileInfo) throws CardApplicationException {
        ICmdSelect cmdSelect = this.getCommand(ICmdSelect.class);
        RequestAPDU req = cmdSelect.createSelectChildDf(targetFile, cmdSelect.getResultType(readFileInfo));
        ResponseAPDU resp = this.sendRequest(cmdSelect, req);
        CardFileInfo info = readFileInfo ? cmdSelect.createCardFileInfo(resp) : null;
        CardFileSelector currentPath = this.getCurrentDf();
        currentPath = currentPath.resolve(targetFile);
        this.setCurrentDf(currentPath, info);
        this.setCurrentEf(null, null);
        return info;
    }

    protected CardFileInfo selectChildEf(CardFileId id, boolean readFileInfo) throws CardApplicationException {
        ICmdSelect cmdSelect = this.getCommand(ICmdSelect.class);
        RequestAPDU req = cmdSelect.createSelectChildEf(id, cmdSelect.getResultType(readFileInfo));
        ResponseAPDU resp = this.sendRequest(cmdSelect, req);
        CardFileInfo info = readFileInfo ? cmdSelect.createCardFileInfo(resp) : null;
        CardFileSelector currentPath = this.getCurrentDf();
        currentPath = currentPath.resolve(id);
        this.setCurrentEf(currentPath, info);
        return info;
    }

    @Override
    public CardFileInfo selectDf(CardFileSelector path, boolean readFileInfo) throws CardApplicationException {
        CardFileName filename = path.getFileName();
        if (filename != null) {
            this.selectRootName(filename, readFileInfo);
        }
        if (path.getFilePath().isAbsolute()) {
            this.selectRootMf(readFileInfo);
        }
        return this.selectDfPath(path.getFilePath(), path.isAbsolute(), readFileInfo);
    }

    protected CardFileInfo selectDfName(CardFileName appId, boolean readFileInfo) throws CardApplicationException {
        this.setCardTransmitter(null);
        ICmdSelect cmdSelect = this.getCommand(ICmdSelect.class);
        RequestAPDU req = cmdSelect.createSelectDfName(appId, cmdSelect.getResultType(readFileInfo));
        ResponseAPDU resp = this.sendRequest(cmdSelect, req);
        CardFileInfo info = readFileInfo ? cmdSelect.createCardFileInfo(resp) : null;
        this.setCurrentDf(appId, info);
        this.setCurrentEf(null, null);
        return info;
    }

    protected CardFileInfo selectDfPath(CardFilePath dirPath, boolean absolute, boolean readFileInfo) throws CardApplicationException {
        CardFilePath currentPath = this.getCurrentDf().getFilePath();
        if (absolute) {
            if (dirPath.equals(currentPath) && (this.getCurrentDfFileInfo() != null || !readFileInfo)) {
                return this.getCurrentDfFileInfo();
            }
            return this.selectDfPathAbsolute(dirPath, readFileInfo);
        }
        return this.selectDfPathRelative(dirPath, readFileInfo);
    }

    protected CardFileInfo selectDfPathAbsolute(CardFilePath dirPath, boolean readFileInfo) throws CardApplicationException {
        CardFilePath currentPath = this.getCurrentDf().getFilePath();
        CardFilePath common = CardFileTools.commonPrefix(currentPath, dirPath);
        CardFileInfo info = null;
        while (common.size() < currentPath.size()) {
            CardFilePath parent = currentPath.getParent();
            info = this.selectParent(readFileInfo);
            currentPath = parent;
        }
        Iterator<CardFileId> current = currentPath.iterator();
        Iterator<CardFileId> target = dirPath.iterator();
        while (current.hasNext() && target.hasNext()) {
            current.next();
            target.next();
        }
        while (target.hasNext()) {
            CardFileId targetFile = target.next();
            info = this.selectChildDf(targetFile, readFileInfo);
        }
        return info;
    }

    protected CardFileInfo selectDfPathRelative(CardFilePath dirPath, boolean readFileInfo) throws CardApplicationException {
        Iterator<CardFileId> target = dirPath.iterator();
        CardFileInfo info = null;
        while (target.hasNext()) {
            CardFileId targetFile = target.next();
            info = this.selectChildDf(targetFile, readFileInfo);
        }
        return info;
    }

    @Override
    public CardFileInfo selectEf(CardFileSelector path, boolean readFileInfo) throws CardApplicationException {
        CardFileSelector absolutePath = this.getCurrentDf().resolve(path);
        this.selectDf(absolutePath.getParent(), false);
        if (path.getFileId().isShort()) {
            return null;
        }
        if (absolutePath.equals(this.getCurrentEf())) {
            if (!readFileInfo) {
                return null;
            }
            if (this.getCurrentEfFileInfo() != null) {
                return this.getCurrentEfFileInfo();
            }
            if (this.getCommand(ICmdSelect.class).getResultType(readFileInfo) == 12) {
                return null;
            }
        }
        return this.selectChildEf(path.getFileId(), readFileInfo);
    }

    @Override
    public CardFileInfo selectParent(boolean readFileInfo) throws CardApplicationException {
        this.setCardTransmitter(null);
        ICmdSelect cmdSelect = this.getCommand(ICmdSelect.class);
        RequestAPDU req = cmdSelect.createSelectParent(cmdSelect.getResultType(readFileInfo));
        CardFileSelector parent = this.getCurrentDf().getParent();
        if (req == null) {
            req = cmdSelect.createSelectAny(parent.getFileId(), cmdSelect.getResultType(readFileInfo));
        }
        ResponseAPDU resp = this.sendRequest(cmdSelect, req);
        CardFileInfo info = readFileInfo ? cmdSelect.createCardFileInfo(resp) : null;
        this.setCurrentDf(parent, info);
        this.setCurrentEf(null, null);
        return info;
    }

    @Override
    public CardFileInfo selectRoot(boolean readFileInfo) throws CardApplicationException {
        this.setCardTransmitter(null);
        ICmdSelect cmdSelect = this.getCommand(ICmdSelect.class);
        RequestAPDU req = cmdSelect.createSelectMf(cmdSelect.getResultType(readFileInfo));
        ResponseAPDU resp = this.sendRequest(cmdSelect, req);
        CardFileInfo info = readFileInfo ? cmdSelect.createCardFileInfo(resp) : null;
        this.setCurrentDf(CardFilePath.ROOT, info);
        this.setCurrentEf(null, null);
        return info;
    }

    protected CardFileInfo selectRootMf(boolean readFileInfo) throws CardApplicationException {
        CardFileSelector currentPath = this.getCurrentDf();
        if (currentPath.getFilePath().isAbsolute()) {
            return null;
        }
        return this.selectRoot(readFileInfo);
    }

    protected CardFileInfo selectRootName(CardFileName appId, boolean readFileInfo) throws CardApplicationException {
        CardFileSelector currentPath = this.getCurrentDf();
        if (currentPath != null && appId.equals(currentPath.getFileName())) {
            return null;
        }
        return this.selectDfName(appId, readFileInfo);
    }

    private void setCachedFile(CardFileSelector file, byte[] content) {
        CardFileSelector absolutePath = this.getCurrentDf().resolve(file);
        this.getCachedFiles().put(absolutePath, content);
    }

    private void setCachedRecord(CardFileSelector file, int index, byte[] content) {
        CardFileSelector absolutePath = this.getCurrentDf().resolve(file);
        this.getCachedRecords(absolutePath).put(index, content);
    }

    public void setSupportsSelectParent(boolean supportsSelectParent) {
        this.supportsSelectParent = supportsSelectParent;
    }

    @Override
    public void updateBinary(CardFileSelector file, int fileOffset, byte[] bytes, int byteOffset, int length) throws CardApplicationException {
        int partialLength;
        this.selectEf(file, false);
        ICmdUpdateBinary cmdRead = this.getCommand(ICmdUpdateBinary.class);
        for (int written = 0; written < length; written += partialLength) {
            partialLength = length - written;
            partialLength = partialLength > 255 ? 255 : partialLength;
            byte[] slice = Arrays.copyOfRange(bytes, byteOffset + written, byteOffset + written + partialLength);
            RequestAPDU req = cmdRead.create(file.getFileId(), fileOffset + written, slice);
            this.sendRequest(cmdRead, req);
        }
    }

    @Override
    public void updateRecord(CardFileSelector file, int recordNumber, byte[] recordData) throws CardApplicationException {
        this.selectEf(file, false);
        ICmdUpdateRecord cmd = this.getCommand(ICmdUpdateRecord.class);
        RequestAPDU req = cmd.create(file.getFileId(), recordNumber, recordData);
        this.sendRequest(cmd, req);
    }
}

