/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.card.debug;

import de.intarsys.security.smartcard.card.CardException;
import de.intarsys.security.smartcard.card.CommonCardSystem;
import de.intarsys.security.smartcard.card.ICardTerminal;
import de.intarsys.security.smartcard.card.debug.DebugCardTerminal;
import de.intarsys.security.smartcard.card.emulator.DebugScript;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DebugCardSystem
extends CommonCardSystem {
    private List<DebugCardTerminal> terminals = new ArrayList<DebugCardTerminal>();
    private DebugScript debugScript;

    public DebugCardTerminal createTerminal() throws CardException {
        DebugCardTerminal terminal = new DebugCardTerminal(this);
        this.terminals.add(terminal);
        return terminal;
    }

    public DebugScript getDebugScript() {
        return this.debugScript;
    }

    public void setDebugScript(DebugScript debugScript) {
        this.debugScript = debugScript;
    }

    public String toString() {
        return "DebugCardSystem";
    }

    protected void updateCardTerminals(Map<String, ICardTerminal> oldTerminals, Map<String, ICardTerminal> newTerminals) {
        for (DebugCardTerminal terminal : this.terminals) {
            ICardTerminal oldTerminal = oldTerminals.remove(terminal.getName());
            if (oldTerminal != null) continue;
            newTerminals.put(terminal.getName(), (ICardTerminal)terminal);
        }
    }
}

