/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.card.emulator;

import de.intarsys.security.smartcard.app.filesystem.CardFileName;
import de.intarsys.security.smartcard.app.filesystem.CardFilePath;
import de.intarsys.security.smartcard.app.filesystem.CardFileSelector;
import de.intarsys.security.smartcard.card.CardException;
import de.intarsys.security.smartcard.card.RequestAPDU;
import de.intarsys.security.smartcard.card.ResponseAPDU;
import de.intarsys.security.smartcard.card.emulator.AbstractCardEmulator;
import de.intarsys.security.smartcard.card.emulator.ISOCardFile;
import java.util.HashMap;
import java.util.Map;

public class ISOCardEmulator
extends AbstractCardEmulator {
    private Map<CardFilePath, ISOCardFile> files = new HashMap<CardFilePath, ISOCardFile>();
    private CardFileSelector currentDirectory = new CardFilePath("3f00");
    private CardFileSelector currentFile;

    public void addFile(CardFilePath path, ISOCardFile file) {
        this.files.put(path, file);
    }

    protected ResponseAPDU createResponseOK() throws CardException {
        return new ResponseAPDU(new byte[]{-112, 0});
    }

    private ResponseAPDU doAppendRecord(int p1, int p2, byte[] data, int le) throws CardException {
        return this.createResponseOK();
    }

    private ResponseAPDU doChangeReferenceData(int p1, int p2, byte[] data, int le) throws CardException {
        return this.createResponseOK();
    }

    private ResponseAPDU doCreate(int p1, int p2, byte[] data, int le) throws CardException {
        return this.createResponseOK();
    }

    private ResponseAPDU doExternalAuthenticate(int p1, int p2, byte[] data, int le) throws CardException {
        return this.createResponseOK();
    }

    private ResponseAPDU doGetChallenge(int p1, int p2, byte[] data, int le) throws CardException {
        return this.createResponseOK();
    }

    private ResponseAPDU doInternalAuthenticate(int p1, int p2, byte[] data, int le) throws CardException {
        return this.createResponseOK();
    }

    private ResponseAPDU doManageSecurityEnvironment(int p1, int p2, byte[] data, int le) throws CardException {
        return this.createResponseOK();
    }

    private ResponseAPDU doPerformSecurityOperation(int p1, int p2, byte[] data, int le) throws CardException {
        return this.createResponseOK();
    }

    private ResponseAPDU doReadBinary(int p1, int p2, byte[] data, int le) throws CardException {
        return this.createResponseOK();
    }

    private ResponseAPDU doReadRecord(int p1, int p2, byte[] data, int le) throws CardException {
        return this.createResponseOK();
    }

    private ResponseAPDU doResetRetryCounter(int p1, int p2, byte[] data, int le) throws CardException {
        return this.createResponseOK();
    }

    protected ResponseAPDU doSelect(int p1, int p2, byte[] data, int le) throws CardException {
        CardFilePath path = new CardFilePath(data);
        switch (p1) {
            case 0: 
            case 1: {
                this.currentFile = this.currentDirectory = this.currentDirectory.resolve(path);
                return this.createResponseOK();
            }
            case 2: {
                this.currentFile = this.currentDirectory.resolve(path);
                return this.createResponseOK();
            }
            case 4: {
                this.currentDirectory = new CardFileName(data);
                return this.createResponseOK();
            }
            case 3: {
                this.currentDirectory = this.currentDirectory.getParent();
                this.currentFile = null;
                return this.createResponseOK();
            }
        }
        throw new CardException("p1 " + p1 + " not supported");
    }

    private ResponseAPDU doUpdateBinary(int p1, int p2, byte[] data, int le) throws CardException {
        return this.createResponseOK();
    }

    private ResponseAPDU doVerify(int p1, int p2, byte[] data, int le) throws CardException {
        return this.createResponseOK();
    }

    public CardFileSelector getCurrentDirectory() {
        return this.currentDirectory;
    }

    public CardFileSelector getCurrentFile() {
        return this.currentFile;
    }

    public ResponseAPDU transmit(RequestAPDU request) throws CardException {
        int ins = request.getIns();
        int p1 = request.getP1();
        int p2 = request.getP2();
        byte[] data = request.getData();
        int le = request.getLe();
        switch (ins) {
            case 32: {
                return this.doVerify(p1, p2, data, le);
            }
            case 34: {
                return this.doManageSecurityEnvironment(p1, p2, data, le);
            }
            case 36: {
                return this.doChangeReferenceData(p1, p2, data, le);
            }
            case 42: {
                return this.doPerformSecurityOperation(p1, p2, data, le);
            }
            case 44: {
                return this.doResetRetryCounter(p1, p2, data, le);
            }
            case 130: {
                return this.doExternalAuthenticate(p1, p2, data, le);
            }
            case 132: {
                return this.doGetChallenge(p1, p2, data, le);
            }
            case 136: {
                return this.doInternalAuthenticate(p1, p2, data, le);
            }
            case 164: {
                return this.doSelect(p1, p2, data, le);
            }
            case 176: {
                return this.doReadBinary(p1, p2, data, le);
            }
            case 178: {
                return this.doReadRecord(p1, p2, data, le);
            }
            case 214: {
                return this.doUpdateBinary(p1, p2, data, le);
            }
            case 224: {
                return this.doCreate(p1, p2, data, le);
            }
            case 226: {
                return this.doAppendRecord(p1, p2, data, le);
            }
        }
        throw new CardException("ins " + ins + " not supported");
    }
}

