/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.cardlet;

import de.intarsys.security.smartcard.card.CardException;
import de.intarsys.security.smartcard.card.ICard;
import de.intarsys.security.smartcard.card.ICardConnection;
import de.intarsys.security.smartcard.cardlet.CardTerminalCardlet;
import de.intarsys.security.smartcard.cardterminal.CardTerminalTools;
import de.intarsys.security.smartcard.cardterminal.ICardTerminalProduct;
import de.intarsys.security.smartcard.cardterminal.IPinEntryApplication;
import de.intarsys.security.smartcard.model.CardProductTools;
import de.intarsys.security.smartcard.model.ICardApplication;
import de.intarsys.security.smartcard.model.ICardProduct;
import de.intarsys.security.smartcard.model.ICommand;
import de.intarsys.security.smartcard.model.app.CardApplicationException;

public abstract class CardConnectionCardlet<R>
extends CardTerminalCardlet<R> {
    private ICardConnection cardConnection;
    private ICardProduct cardProduct;
    private ICardTerminalProduct cardTerminalProduct;

    protected CardConnectionCardlet() {
    }

    protected CardConnectionCardlet(ICardConnection cardConnection) {
        super(cardConnection.getCardTerminal());
        this.cardConnection = cardConnection;
    }

    @Override
    protected Object basicGetCardContext() {
        StringBuilder sb = new StringBuilder();
        sb.append("Card terminal: ");
        if (this.getCardTerminal() == null) {
            sb.append("no card terminal");
        } else {
            sb.append(this.getCardTerminalName());
            if (this.getCardTerminalProduct() != null) {
                sb.append("\n");
                sb.append("Card terminal product: ");
                sb.append(this.getCardTerminalProduct().getVendor());
                sb.append(" - ");
                sb.append(this.getCardTerminalProduct().getName());
            }
            try {
                if (this.getCardProduct() != null) {
                    sb.append("\n");
                    sb.append("Card product: ");
                    sb.append(this.getCardProduct().getIssuer());
                    sb.append(" - ");
                    sb.append(this.getCardProduct().getName());
                }
            }
            catch (CardApplicationException e) {
                sb.append("\n");
                sb.append(e.getMessage());
            }
        }
        return sb.toString();
    }

    protected <T extends ICardApplication> T createCardApplication(Class<T> clazz) throws CardApplicationException, CardException {
        return this.getCardProduct().createCardApplication(this.getCardConnection(), clazz);
    }

    protected ICardProduct createCardProduct() throws CardApplicationException {
        return CardProductTools.getCardProduct(this.getCardConnection());
    }

    protected ICardTerminalProduct createCardTerminalProduct() {
        return CardTerminalTools.getCardTerminalProduct(this.getCardConnection());
    }

    protected <T extends ICommand> T createCommand(Class<T> command) throws CardApplicationException {
        return this.getCardProduct().getCardOperatingSystem().getCommand(command);
    }

    @Override
    public ICard getCard() {
        return this.cardConnection.getCard();
    }

    public ICardConnection getCardConnection() {
        return this.cardConnection;
    }

    public ICardProduct getCardProduct() throws CardApplicationException {
        if (this.cardProduct == null) {
            this.cardProduct = this.createCardProduct();
        }
        return this.cardProduct;
    }

    public ICardTerminalProduct getCardTerminalProduct() {
        if (this.cardTerminalProduct == null) {
            this.cardTerminalProduct = this.createCardTerminalProduct();
        }
        return this.cardTerminalProduct;
    }

    protected IPinEntryApplication getPinEntryApplication() throws CardApplicationException {
        return this.getCardTerminalProduct().createCardApplication(this.getCardConnection(), IPinEntryApplication.class);
    }

    public void setCardConnection(ICardConnection cardConnection) {
        this.cardConnection = cardConnection;
        if (cardConnection == null) {
            this.setCardTerminal(null);
        } else {
            this.setCardTerminal(cardConnection.getCardTerminal());
        }
    }

    public void setCardProduct(ICardProduct cardProduct) {
        this.cardProduct = cardProduct;
    }

    public void setCardTerminalProduct(ICardTerminalProduct cardTerminalProduct) {
        this.cardTerminalProduct = cardTerminalProduct;
    }
}

