/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.cardlet;

import de.intarsys.security.smartcard.card.ICard;
import de.intarsys.security.smartcard.card.ICardTerminal;
import de.intarsys.security.smartcard.cardlet.CardSystemCardlet;

public abstract class CardTerminalCardlet<R>
extends CardSystemCardlet<R> {
    private ICardTerminal cardTerminal;

    protected CardTerminalCardlet() {
    }

    protected CardTerminalCardlet(ICardTerminal cardTerminal) {
        super(cardTerminal.getCardSystem());
        this.cardTerminal = cardTerminal;
    }

    @Override
    protected Object basicGetCardContext() {
        if (this.cardTerminal == null) {
            return "no card terminal";
        }
        return this.cardTerminal.getName();
    }

    public ICard getCard() {
        if (this.cardTerminal == null) {
            return null;
        }
        return this.cardTerminal.getCard();
    }

    public ICardTerminal getCardTerminal() {
        return this.cardTerminal;
    }

    public String getCardTerminalName() {
        return this.getCardTerminal().getName();
    }

    protected boolean isReinerSCT() {
        String name = this.getCardTerminalName().toLowerCase();
        return name.contains("reiner") || name.contains("cyberjack");
    }

    public void setCardTerminal(ICardTerminal cardTerminal) {
        this.cardTerminal = cardTerminal;
        if (cardTerminal == null) {
            this.setCardSystem(null);
        } else {
            this.setCardSystem(cardTerminal.getCardSystem());
        }
    }
}

