/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.cardterminal;

import de.intarsys.security.smartcard.card.CardException;
import de.intarsys.security.smartcard.card.ICardConnection;
import de.intarsys.security.smartcard.pcsc.PCSCAttribute;
import de.intarsys.security.smartcard.pcsc.PCSCException;
import de.intarsys.security.smartcard.pcsc.PCSCTools;

public class AttributeReader {
    private ICardConnection connection;

    public AttributeReader(ICardConnection connection) {
        this.connection = connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAttrDeviceFriendlyName() throws CardException {
        AttributeReader attributeReader = this;
        synchronized (attributeReader) {
            byte[] buffer = this.connection.getAttrib(PCSCAttribute.SCARD_ATTR_DEVICE_FRIENDLY_NAME_A);
            return PCSCTools.toString((byte[])buffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAttrDeviceSystemName() throws CardException {
        AttributeReader attributeReader = this;
        synchronized (attributeReader) {
            byte[] buffer = this.connection.getAttrib(PCSCAttribute.SCARD_ATTR_DEVICE_SYSTEM_NAME_A);
            return PCSCTools.toString((byte[])buffer);
        }
    }

    public String getAttrVendorIfdSerialNo() throws CardException {
        AttributeReader attributeReader = this;
        synchronized (attributeReader) {
            try {
                byte[] buffer = this.connection.getAttrib(PCSCAttribute.SCARD_ATTR_VENDOR_IFD_SERIAL_NO);
                return PCSCTools.toString((byte[])buffer);
            }
            catch (CardException e) {
                if (e.getCause() instanceof PCSCException && ((PCSCException)e.getCause()).getErrorCode() == 50) {
                    return "0";
                }
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAttrVendorIfdType() throws CardException {
        AttributeReader attributeReader = this;
        synchronized (attributeReader) {
            byte[] buffer = this.connection.getAttrib(PCSCAttribute.SCARD_ATTR_VENDOR_IFD_TYPE);
            return PCSCTools.toString((byte[])buffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getAttrVendorIfdVersion() throws CardException {
        AttributeReader attributeReader = this;
        synchronized (attributeReader) {
            byte[] buffer = this.connection.getAttrib(PCSCAttribute.SCARD_ATTR_VENDOR_IFD_VERSION);
            StringBuilder versionString = new StringBuilder();
            for (int i = buffer.length - 1; i >= 0; --i) {
                byte b = buffer[i];
                if (versionString.length() > 0) {
                    versionString.append('.');
                }
                versionString.append(b);
            }
            return versionString.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getByteValue(int attribId) throws CardException {
        AttributeReader attributeReader = this;
        synchronized (attributeReader) {
            byte[] buffer = this.connection.getAttrib(attribId);
            return buffer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getStringValue(int attribId) throws CardException {
        AttributeReader attributeReader = this;
        synchronized (attributeReader) {
            byte[] buffer = this.connection.getAttrib(attribId);
            return PCSCTools.toString((byte[])buffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getVendorName() throws CardException {
        AttributeReader attributeReader = this;
        synchronized (attributeReader) {
            byte[] buffer = this.connection.getAttrib(PCSCAttribute.SCARD_ATTR_VENDOR_NAME);
            return PCSCTools.toString((byte[])buffer);
        }
    }
}

