/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.cardterminal;

import de.intarsys.security.smartcard.card.ICardTerminal;
import de.intarsys.security.smartcard.cardterminal.CardTerminalTools;
import de.intarsys.security.smartcard.cardterminal.FeatureList;
import de.intarsys.security.smartcard.cardterminal.ICardTerminalProduct;
import de.intarsys.security.smartcard.model.app.AbstractCardApplication;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.tools.message.IMessage;
import de.intarsys.tools.message.LiteralMessage;
import jakarta.annotation.PostConstruct;

public abstract class CardTerminalApplicationAdapter
extends AbstractCardApplication {
    private FeatureList featureList;
    private ICardTerminalProduct cardTerminalProduct;

    @Override
    public IMessage getAuthenticationPromptExpanded() {
        return LiteralMessage.create((String)"unused");
    }

    public ICardTerminal getCardTerminal() {
        return this.getCardConnection().getCardTerminal();
    }

    public String getCardTerminalName() {
        return this.getCardTerminal().getName();
    }

    public ICardTerminalProduct getCardTerminalProduct() {
        return this.cardTerminalProduct;
    }

    public FeatureList getFeatureList() {
        return this.featureList;
    }

    @PostConstruct
    public void initialize() throws CardApplicationException {
        this.featureList = this.readFeatureList();
    }

    protected FeatureList readFeatureList() throws CardApplicationException {
        return CardTerminalTools.getFeatureList(this.getCardConnection());
    }

    public void setCardTerminalProduct(ICardTerminalProduct cardTerminalProduct) {
        this.cardTerminalProduct = cardTerminalProduct;
    }

    public void setFeatureList(FeatureList featureList) {
        this.featureList = featureList;
    }
}

