/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.cardterminal;

import de.intarsys.security.smartcard.cardterminal.FeatureList;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.tools.reflect.InvocableMethod;

public class CardTerminalState {
    private final String firmwareVersion;
    private final String hardwareVersion;
    private final String serialNumber;
    private final String vendor;
    private final String deviceFriendlyName;
    private final String deviceSystemName;
    private final String type;
    private final FeatureList featureList;
    private final String name;
    private final String driverVersion;
    private final CardApplicationException exception;

    public static CardTerminalState createFailed(CardApplicationException e) {
        return new CardTerminalState(e);
    }

    protected CardTerminalState(CardApplicationException exception) {
        this.exception = exception;
        this.vendor = "";
        this.name = "";
        this.type = "";
        this.serialNumber = "";
        this.hardwareVersion = "";
        this.firmwareVersion = "";
        this.driverVersion = "";
        this.deviceFriendlyName = "";
        this.deviceSystemName = "";
        this.featureList = new FeatureList(new byte[0]);
    }

    public CardTerminalState(String vendor, String name, String type, String serialNumber, String hardwareVersion, String firmwareVersion, String driverVersion, String deviceFriendlyName, String deviceSystemName, FeatureList featureList) {
        this.vendor = this.checkNull(vendor);
        this.name = this.checkNull(name);
        this.type = this.checkNull(type);
        this.serialNumber = this.checkNull(serialNumber);
        this.hardwareVersion = this.checkNull(hardwareVersion);
        this.firmwareVersion = this.checkNull(firmwareVersion);
        this.driverVersion = this.checkNull(driverVersion);
        this.deviceFriendlyName = this.checkNull(deviceFriendlyName);
        this.deviceSystemName = this.checkNull(deviceSystemName);
        this.featureList = featureList;
        this.exception = null;
    }

    private String checkNull(String value) {
        return value == null ? "" : value;
    }

    public String getDeviceFriendlyName() {
        return this.deviceFriendlyName;
    }

    public String getDeviceSystemName() {
        return this.deviceSystemName;
    }

    public String getDriverVersion() {
        return this.driverVersion;
    }

    public CardApplicationException getException() {
        return this.exception;
    }

    public FeatureList getFeatureList() {
        return this.featureList;
    }

    @InvocableMethod
    public String getFirmwareVersion() {
        return this.firmwareVersion;
    }

    @InvocableMethod
    public String getHardwareVersion() {
        return this.hardwareVersion;
    }

    @InvocableMethod
    public String getName() {
        return this.name;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public String getType() {
        return this.type;
    }

    public String getVendor() {
        return this.vendor;
    }

    public boolean isFailed() {
        return this.exception != null;
    }

    public String toString() {
        return "CardTerminalState [firmwareVersion=" + this.firmwareVersion + ", hardwareVersion=" + this.hardwareVersion + ", serialNumber=" + this.serialNumber + ", vendor=" + this.vendor + ", deviceFriendlyName=" + this.deviceFriendlyName + ", deviceSystemName=" + this.deviceSystemName + ", type=" + this.type + ", featureList=" + this.featureList + ", name=" + this.name + ", driverVersion=" + this.driverVersion + "]";
    }
}

