/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.cardterminal;

import de.intarsys.security.smartcard.card.CardException;
import de.intarsys.security.smartcard.card.CardReset;
import de.intarsys.security.smartcard.card.CardUnavailable;
import de.intarsys.security.smartcard.cardterminal.AttributeReader;
import de.intarsys.security.smartcard.cardterminal.CardTerminalApplicationAdapter;
import de.intarsys.security.smartcard.cardterminal.CardTerminalState;
import de.intarsys.security.smartcard.cardterminal.ICardTerminalStateApplication;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.tools.string.StringTools;
import jakarta.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CardTerminalStateApplication
extends CardTerminalApplicationAdapter
implements ICardTerminalStateApplication {
    private static final Logger Log = LoggerFactory.getLogger(CardTerminalStateApplication.class);
    private CardTerminalState state;

    @Override
    public CardTerminalState getCardTerminalState() {
        return this.state;
    }

    @Override
    @PostConstruct
    public void initialize() throws CardApplicationException {
        super.initialize();
        this.state = this.readAttributeList();
    }

    protected CardTerminalState readAttributeList() throws CardApplicationException {
        AttributeReader attrReader = new AttributeReader(this.getCardConnection());
        String vendor = this.readVendor(attrReader);
        String type = this.readType(attrReader);
        String serialNo = this.readSerialNumber(attrReader);
        String hardwareVersion = this.readHardwareVersion(attrReader);
        String firmwareVersion = this.readFirmwareVersion(attrReader);
        String driverVersion = this.readDriverVersion(attrReader);
        String deviceFriendlyName = this.readDeviceFriendlyName(attrReader);
        String deviceSystemName = this.readDeviceSystemName(attrReader);
        String name = StringTools.isEmpty((String)deviceFriendlyName) ? this.getCardTerminalName() : deviceFriendlyName;
        return new CardTerminalState(vendor, name, type, serialNo, hardwareVersion, firmwareVersion, driverVersion, deviceFriendlyName, deviceSystemName, this.getFeatureList());
    }

    protected String readDeviceFriendlyName(AttributeReader attrReader) throws CardApplicationException {
        try {
            return attrReader.getAttrDeviceFriendlyName();
        }
        catch (CardReset | CardUnavailable e) {
            throw CardApplicationException.create(e);
        }
        catch (CardException e) {
            Log.debug(e.getLocalizedMessage(), (Throwable)e);
            return "";
        }
    }

    protected String readDeviceSystemName(AttributeReader attrReader) throws CardApplicationException {
        try {
            return attrReader.getAttrDeviceSystemName();
        }
        catch (CardReset | CardUnavailable e) {
            throw CardApplicationException.create(e);
        }
        catch (CardException e) {
            Log.debug(e.getLocalizedMessage(), (Throwable)e);
            return "";
        }
    }

    protected String readDriverVersion(AttributeReader attrReader) throws CardApplicationException {
        return "";
    }

    protected String readFirmwareVersion(AttributeReader attrReader) throws CardApplicationException {
        return this.readHardwareVersion(attrReader);
    }

    protected String readHardwareVersion(AttributeReader attrReader) throws CardApplicationException {
        try {
            return attrReader.getAttrVendorIfdVersion();
        }
        catch (CardReset | CardUnavailable e) {
            throw CardApplicationException.create(e);
        }
        catch (CardException e) {
            Log.debug(e.getLocalizedMessage(), (Throwable)e);
            return "";
        }
    }

    protected String readSerialNumber(AttributeReader attrReader) throws CardApplicationException {
        try {
            return attrReader.getAttrVendorIfdSerialNo();
        }
        catch (CardReset | CardUnavailable e) {
            throw CardApplicationException.create(e);
        }
        catch (CardException e) {
            Log.debug(e.getLocalizedMessage(), (Throwable)e);
            return "";
        }
    }

    protected String readType(AttributeReader attrReader) throws CardApplicationException {
        try {
            return attrReader.getAttrVendorIfdType();
        }
        catch (CardReset | CardUnavailable e) {
            throw CardApplicationException.create(e);
        }
        catch (CardException e) {
            Log.debug(e.getLocalizedMessage(), (Throwable)e);
            return "";
        }
    }

    protected String readVendor(AttributeReader attrReader) throws CardApplicationException {
        try {
            return attrReader.getVendorName();
        }
        catch (CardReset | CardUnavailable e) {
            throw CardApplicationException.create(e);
        }
        catch (CardException e) {
            Log.debug(e.getLocalizedMessage(), (Throwable)e);
            return "";
        }
    }

    public String toString() {
        if (this.state != null) {
            return this.state.toString();
        }
        return super.toString();
    }
}

