/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.cardterminal;

import de.intarsys.security.smartcard.card.CardException;
import de.intarsys.security.smartcard.card.ICardConnection;
import de.intarsys.security.smartcard.card.ICardTerminal;
import de.intarsys.security.smartcard.cardterminal.CardTerminalProductRegistry;
import de.intarsys.security.smartcard.cardterminal.CardTerminalState;
import de.intarsys.security.smartcard.cardterminal.FeatureList;
import de.intarsys.security.smartcard.cardterminal.ICardTerminalProduct;
import de.intarsys.security.smartcard.cardterminal.ICardTerminalStateApplication;
import de.intarsys.security.smartcard.cardterminal.StandardCardTerminalProduct;
import de.intarsys.security.smartcard.model.app.CardApplicationCardReset;
import de.intarsys.security.smartcard.model.app.CardApplicationCardUnavailable;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.tools.attribute.Attribute;
import de.intarsys.tools.exception.ExceptionTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class CardTerminalTools {
    private static final Logger Log = LoggerFactory.getLogger(CardTerminalTools.class);
    private static final Attribute ATTR_CARDTERMINALPRODUCT = new Attribute("cardTerminalProduct");
    private static final Attribute ATTR_CARDTERMINALSTATE = new Attribute("cardTerminalState");
    static final Attribute ATTR_FEATURELIST = new Attribute("featureList");
    static final Attribute ATTR_FEATURELISTBASIC = new Attribute("basicFeatureList");

    public static CardTerminalState createFailedState(ICardTerminal terminal, CardApplicationException exception) {
        Log.info("can not read card terminal state (" + exception.getMessage() + ")");
        CardTerminalState state = CardTerminalState.createFailed(exception);
        CardTerminalTools.setCardTerminalState(terminal, state);
        return state;
    }

    public static ICardTerminalProduct getCardTerminalProduct(ICardConnection connection) {
        ICardTerminal terminal = connection.getCardTerminal();
        ICardTerminalProduct result = CardTerminalTools.getCardTerminalProduct(terminal);
        if (result == null) {
            Log.trace("search card terminal product");
            for (ICardTerminalProduct product : CardTerminalProductRegistry.get().getCardTerminalProducts()) {
                if (!product.accept(connection)) continue;
                result = product;
                break;
            }
            if (result == null) {
                Log.trace("no card terminal product found, use default");
                result = new StandardCardTerminalProduct();
            }
            terminal.setAttribute((Object)ATTR_CARDTERMINALPRODUCT, (Object)result);
            if (Log.isEnabledForLevel(Level.DEBUG)) {
                CardTerminalTools.logProductDetails(result, connection);
            }
        }
        return result;
    }

    public static ICardTerminalProduct getCardTerminalProduct(ICardTerminal terminal) {
        return (ICardTerminalProduct)terminal.getAttribute((Object)ATTR_CARDTERMINALPRODUCT);
    }

    public static CardTerminalState getCardTerminalState(ICardConnection connection) throws CardApplicationException {
        ICardTerminal terminal = connection.getCardTerminal();
        CardTerminalState state = CardTerminalTools.getCardTerminalState(terminal);
        if (state == null) {
            try {
                ICardTerminalProduct product = CardTerminalTools.getCardTerminalProduct(connection);
                ICardTerminalStateApplication stateApp = product.createCardApplication(connection, ICardTerminalStateApplication.class);
                state = stateApp.getCardTerminalState();
                CardTerminalTools.setCardTerminalState(terminal, state);
            }
            catch (CardApplicationCardReset | CardApplicationCardUnavailable e) {
                throw e;
            }
            catch (CardApplicationException e) {
                state = CardTerminalTools.createFailedState(terminal, e);
            }
            if (Log.isEnabledForLevel(Level.DEBUG)) {
                CardTerminalTools.logStateDetails(state, connection);
            }
        }
        return state;
    }

    public static CardTerminalState getCardTerminalState(ICardTerminal terminal) {
        return (CardTerminalState)terminal.getAttribute((Object)ATTR_CARDTERMINALSTATE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FeatureList getFeatureList(ICardConnection connection) throws CardApplicationException {
        ICardTerminal terminal = connection.getCardTerminal();
        Class<CardTerminalTools> clazz = CardTerminalTools.class;
        synchronized (CardTerminalTools.class) {
            FeatureList featureList = CardTerminalTools.getFeatureList(terminal);
            if (featureList == null) {
                try {
                    featureList = CardTerminalTools.readFeatureList(connection);
                    CardTerminalTools.setFeatureList(terminal, featureList);
                }
                catch (CardApplicationCardReset | CardApplicationCardUnavailable e) {
                    throw e;
                }
                catch (CardApplicationException e) {
                    Log.info("can not read feature list ({})", (Object)ExceptionTools.getMessage((Throwable)e));
                    featureList = new FeatureList(new byte[0]);
                    CardTerminalTools.setFeatureList(terminal, featureList);
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return featureList;
        }
    }

    public static FeatureList getFeatureList(ICardTerminal terminal) {
        return (FeatureList)terminal.getAttribute((Object)ATTR_FEATURELIST);
    }

    protected static void logProductDetails(ICardTerminalProduct product, ICardConnection connection) {
        Log.debug("card terminal product details");
        Log.debug("+ id: " + product.getId());
        Log.debug("+ name: " + product.getName());
        Log.debug("+ static vendor: " + product.getVendor());
    }

    protected static void logStateDetails(CardTerminalState state, ICardConnection connection) {
        Log.debug("card terminal state details");
        try {
            Log.debug("+ vendor: " + state.getVendor());
            Log.debug("+ name: " + state.getName());
            Log.debug("+ type: " + state.getType());
            Log.debug("+ friendly name: " + state.getDeviceFriendlyName());
            Log.debug("+ hardware: " + state.getHardwareVersion());
            Log.debug("+ firmware: " + state.getFirmwareVersion());
            Log.debug("+ features: " + state.getFeatureList());
        }
        catch (Exception e) {
            Log.debug("+ error logging card terminal state details (" + e.getMessage() + ")");
        }
    }

    public static FeatureList readFeatureList(ICardConnection connection) throws CardApplicationException {
        try {
            int code = 3400;
            byte[] bytes = connection.controlMapped(code, null, 0, 0, 256);
            ICardTerminal terminal = connection.getCardTerminal();
            FeatureList featureList = new FeatureList(bytes);
            Log.debug("card terminal '{}' feature list '{}'", (Object)terminal.getName(), (Object)featureList);
            return featureList;
        }
        catch (CardException e) {
            throw CardApplicationException.create(e);
        }
    }

    protected static void setCardTerminalState(ICardTerminal terminal, CardTerminalState state) {
        terminal.setAttribute((Object)ATTR_CARDTERMINALSTATE, (Object)state);
    }

    protected static void setFeatureList(ICardTerminal terminal, FeatureList features) {
        terminal.setAttribute((Object)ATTR_FEATURELIST, (Object)features);
    }

    private CardTerminalTools() {
    }
}

