/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.cardterminal;

import de.intarsys.security.smartcard.card.ICardConnection;
import de.intarsys.security.smartcard.card.ICardTerminal;
import de.intarsys.security.smartcard.card.RequestAPDU;
import de.intarsys.security.smartcard.cardterminal.CardTerminalStateApplication;
import de.intarsys.security.smartcard.cardterminal.CardTerminalTools;
import de.intarsys.security.smartcard.cardterminal.EmbeddedPaceApplication;
import de.intarsys.security.smartcard.cardterminal.FeatureListApplication;
import de.intarsys.security.smartcard.cardterminal.ICardTerminalProduct;
import de.intarsys.security.smartcard.cardterminal.ICardTerminalStateApplication;
import de.intarsys.security.smartcard.cardterminal.IFeatureListApplication;
import de.intarsys.security.smartcard.cardterminal.IPinEntryApplication;
import de.intarsys.security.smartcard.cardterminal.PACKAGE;
import de.intarsys.security.smartcard.cardterminal.PinEntryApplication;
import de.intarsys.security.smartcard.common.IPinCodec;
import de.intarsys.security.smartcard.environment.SmartcardEnvironment;
import de.intarsys.security.smartcard.model.ICardApplication;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.security.smartcard.pcsc.nativec.PIN_MODIFY_STRUCTURE;
import de.intarsys.security.smartcard.pcsc.nativec.PIN_VERIFY_STRUCTURE;
import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.IElementConfigurable;
import de.intarsys.tools.message.IMessage;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.nls.LocaleTools;
import de.intarsys.tr3110.pace.IPaceApplication;
import java.util.Locale;

public abstract class CommonCardTerminalProduct
implements ICardTerminalProduct,
IElementConfigurable {
    private static final IMessageBundle Msg = PACKAGE.Messages;
    private String id;

    @Override
    public boolean accept(ICardConnection channel) {
        return false;
    }

    protected PIN_MODIFY_STRUCTURE applyCardReaderFixes(IPinCodec pinCodec, PIN_MODIFY_STRUCTURE modifyStr, boolean enterCurrentPIN) {
        return modifyStr;
    }

    protected PIN_VERIFY_STRUCTURE applyCardReaderFixes(IPinCodec pinCodec, PIN_VERIFY_STRUCTURE verifyStr) {
        return verifyStr;
    }

    public void configure(IElement element) throws ConfigurationException {
        this.setId(ElementTools.getString((IElement)element, (String)"id", (String)this.getId()));
    }

    @Override
    public <T extends ICardApplication> T createCardApplication(ICardConnection connection, Class<T> clazz) throws CardApplicationException {
        if (IPinEntryApplication.class.isAssignableFrom(clazz)) {
            return (T)this.createPinEntryApplication(connection);
        }
        if (IFeatureListApplication.class.isAssignableFrom(clazz)) {
            return (T)this.createFeatureListApplication(connection);
        }
        if (IPaceApplication.class.isAssignableFrom(clazz)) {
            return (T)this.createPaceApplication(connection);
        }
        if (ICardTerminalStateApplication.class.isAssignableFrom(clazz)) {
            return (T)this.createStateApplication(connection);
        }
        throw new CardApplicationException("unknown ICardApplication " + clazz);
    }

    protected IFeatureListApplication createFeatureListApplication(ICardConnection connection) throws CardApplicationException {
        FeatureListApplication app = new FeatureListApplication();
        app.setCardTerminalProduct(this);
        app.setCardConnection(connection);
        app.initialize();
        return app;
    }

    protected int createFormatString(IPinCodec pinCodec) {
        int result = 0;
        result |= pinCodec.getFormatUnit() << 7;
        result |= pinCodec.getFormatPosition() << 3;
        result |= pinCodec.getFormatJustification() << 2;
        return result |= pinCodec.getFormatFormat();
    }

    protected IPaceApplication createPaceApplication(ICardConnection connection) throws CardApplicationException {
        EmbeddedPaceApplication app = new EmbeddedPaceApplication();
        app.setCardTerminalProduct(this);
        app.setCardConnection(connection);
        app.initialize();
        return app;
    }

    protected int createPinBlockString(IPinCodec pinCodec) {
        int result = 0;
        result |= pinCodec.getPinBlockPinLengthSize() << 4;
        return result |= pinCodec.getPinBlockPinSize();
    }

    protected IPinEntryApplication createPinEntryApplication(ICardConnection connection) throws CardApplicationException {
        PinEntryApplication app = new PinEntryApplication();
        app.setCardTerminalProduct(this);
        int timeout = SmartcardEnvironment.get().getSpeTimeout();
        int timeoutKey = SmartcardEnvironment.get().getSpeTimeoutAfterFirstKeyPress();
        app.setTimeout(timeout);
        app.setTimeoutKeyPress(timeoutKey);
        app.setLockDirect(this.isLockDirect());
        app.setCardConnection(connection);
        app.initialize();
        return app;
    }

    protected int createPinLengthFormat(IPinCodec pinCodec) {
        int result = 0;
        result |= pinCodec.getPinLengthUnit() << 4;
        return result |= pinCodec.getPinLengthPosition();
    }

    public PIN_MODIFY_STRUCTURE createPINModifyStructure(RequestAPDU apdu, IPinCodec pinCodec, boolean enterCurrentPIN, int timeout, int timeoutKeyPress) {
        PIN_MODIFY_STRUCTURE modifyStr = new PIN_MODIFY_STRUCTURE(apdu.getLength());
        modifyStr.setTimeOut(timeout);
        modifyStr.setTimeOut2(timeoutKeyPress);
        int formatString = this.createFormatString(pinCodec);
        modifyStr.setFormatString(formatString);
        int pinBlockString = this.createPinBlockString(pinCodec);
        modifyStr.setPINBlockString(pinBlockString);
        int pinLengthFormat = this.createPinLengthFormat(pinCodec);
        modifyStr.setPINLengthFormat(pinLengthFormat);
        modifyStr.setInsertionOffsetOld(0);
        modifyStr.setInsertionOffsetNew(pinCodec.getInsertionOffsetNew(enterCurrentPIN));
        int maxCharacters = pinCodec.getMaxCharacters();
        if (maxCharacters > 16) {
            maxCharacters = 16;
        }
        modifyStr.setPINMaxExtraDigit(pinCodec.getMinCharacters(), maxCharacters);
        modifyStr.setEntryValidationCondition(2);
        if (enterCurrentPIN) {
            modifyStr.setConfirmPIN(3);
            modifyStr.setNumberMessage(3);
            modifyStr.setMsgIndex1(0);
            modifyStr.setMsgIndex2(1);
            modifyStr.setMsgIndex3(2);
        } else {
            modifyStr.setConfirmPIN(1);
            modifyStr.setNumberMessage(2);
            modifyStr.setMsgIndex1(1);
            modifyStr.setMsgIndex2(2);
            modifyStr.setMsgIndex3(0);
        }
        int langId = LocaleTools.getLcid((Locale)Locale.getDefault());
        modifyStr.setLangId(langId);
        modifyStr.setApdu(apdu.getBytes(), 0, apdu.getLength());
        return this.applyCardReaderFixes(pinCodec, modifyStr, enterCurrentPIN);
    }

    public PIN_VERIFY_STRUCTURE createPINVerifyStructure(RequestAPDU apdu, IPinCodec pinCodec, int timeout, int timeoutKeyPress) {
        PIN_VERIFY_STRUCTURE verifyStr = new PIN_VERIFY_STRUCTURE(pinCodec.getApduDataSize());
        verifyStr.setTimeOut(timeout);
        verifyStr.setTimeOut2(timeoutKeyPress);
        int formatString = this.createFormatString(pinCodec);
        verifyStr.setFormatString(formatString);
        int pinBlockString = this.createPinBlockString(pinCodec);
        verifyStr.setPINBlockString(pinBlockString);
        int pinLengthFormat = this.createPinLengthFormat(pinCodec);
        verifyStr.setPINLengthFormat(pinLengthFormat);
        int maxCharacters = pinCodec.getMaxCharacters();
        if (maxCharacters > 16) {
            maxCharacters = 16;
        }
        verifyStr.setPINMaxExtraDigit(pinCodec.getMinCharacters(), maxCharacters);
        verifyStr.setEntryValidationCondition(2);
        verifyStr.setNumberMessage(1);
        int langId = LocaleTools.getLcid((Locale)Locale.getDefault());
        verifyStr.setLangId(langId);
        verifyStr.setMsgIndex(0);
        verifyStr.setApdu(apdu.getBytes(), 0, pinCodec.getApduDataSize());
        return this.applyCardReaderFixes(pinCodec, verifyStr);
    }

    protected ICardTerminalStateApplication createStateApplication(ICardConnection connection) throws CardApplicationException {
        CardTerminalStateApplication ctc = new CardTerminalStateApplication();
        ctc.setCardTerminalProduct(this);
        ctc.setCardConnection(connection);
        ctc.initialize();
        return ctc;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public IMessage[] getModifyInstructions(ICardTerminal cardTerminal) {
        IMessage msgCurrent = Msg.getMessage("CommonCardTerminalProduct.enterCurrentPin", new Object[]{cardTerminal.getName()});
        IMessage msgNew = Msg.getMessage("CommonCardTerminalProduct.enterNewPin", new Object[]{cardTerminal.getName()});
        IMessage msgNewRepeat = Msg.getMessage("CommonCardTerminalProduct.repeatNewPin", new Object[]{cardTerminal.getName()});
        return new IMessage[]{msgCurrent, msgNew, msgNewRepeat};
    }

    @Override
    public String getName() {
        return this.getId();
    }

    protected boolean isLockDirect() {
        return false;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean supportsPace(ICardConnection connection) throws CardApplicationException {
        try {
            return CardTerminalTools.getFeatureList(connection).getExecutePace() != 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean supportsPinModify(IPinCodec pinCodec) {
        return true;
    }

    public boolean supportsPinVerify(IPinCodec pinCodec) {
        return true;
    }
}

