/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.cardterminal;

import de.intarsys.security.smartcard.card.CardException;
import de.intarsys.security.smartcard.card.CardReset;
import de.intarsys.security.smartcard.card.CardUnavailable;
import de.intarsys.security.smartcard.card.RequestAPDU;
import de.intarsys.security.smartcard.card.ResponseAPDU;
import de.intarsys.security.smartcard.cardterminal.AttributeReader;
import de.intarsys.security.smartcard.cardterminal.CardTerminalStateApplication;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.tools.system.SystemTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EIDCardTerminalStateApplication
extends CardTerminalStateApplication {
    private static final Logger Log = LoggerFactory.getLogger(EIDCardTerminalStateApplication.class);

    @Override
    protected String readDriverVersion(AttributeReader attrReader) throws CardApplicationException {
        if (SystemTools.isMac()) {
            return super.readDriverVersion(attrReader);
        }
        try {
            RequestAPDU request = new RequestAPDU(255, 154, 1, 7, 0, false);
            request.setLabel("EID get driver version");
            ResponseAPDU res = this.getCardConnection().transmit(request);
            return new String(res.getData());
        }
        catch (CardReset | CardUnavailable e) {
            throw CardApplicationException.create(e);
        }
        catch (CardException e) {
            Log.debug("Failed reading TR-3119 attribute 'driver':" + e.getLocalizedMessage());
            return super.readDriverVersion(attrReader);
        }
    }

    @Override
    protected String readFirmwareVersion(AttributeReader attrReader) throws CardApplicationException {
        if (SystemTools.isMac()) {
            return super.readFirmwareVersion(attrReader);
        }
        try {
            RequestAPDU request = new RequestAPDU(255, 154, 1, 6, 0, false);
            request.setLabel("EID get firmwares version");
            ResponseAPDU res = this.getCardConnection().transmit(request);
            return new String(res.getData());
        }
        catch (CardReset | CardUnavailable e) {
            throw CardApplicationException.create(e);
        }
        catch (CardException e) {
            Log.debug("Failed reading TR-3119 attribute 'firmware':" + e.getLocalizedMessage());
            return super.readFirmwareVersion(attrReader);
        }
    }

    @Override
    protected String readType(AttributeReader attrReader) throws CardApplicationException {
        if (SystemTools.isMac()) {
            return super.readType(attrReader);
        }
        try {
            RequestAPDU request = new RequestAPDU(255, 154, 1, 3, 0, false);
            request.setLabel("EID get product");
            ResponseAPDU res = this.getCardConnection().transmit(request);
            return new String(res.getData());
        }
        catch (CardReset | CardUnavailable e) {
            throw CardApplicationException.create(e);
        }
        catch (CardException e) {
            Log.debug("Failed reading TR-3119 attribute 'product':" + e.getLocalizedMessage());
            return super.readType(attrReader);
        }
    }

    @Override
    protected String readVendor(AttributeReader attrReader) throws CardApplicationException {
        if (SystemTools.isMac()) {
            return super.readVendor(attrReader);
        }
        try {
            RequestAPDU request = new RequestAPDU(255, 154, 1, 1, 0, false);
            request.setLabel("EID get vendor");
            ResponseAPDU res = this.getCardConnection().transmit(request);
            return new String(res.getData());
        }
        catch (CardReset | CardUnavailable e) {
            throw CardApplicationException.create(e);
        }
        catch (CardException e) {
            Log.debug("Failed reading TR-3119 attribute 'vendor':" + e.getLocalizedMessage());
            return super.readVendor(attrReader);
        }
    }
}

