/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.cardterminal;

import de.intarsys.security.smartcard.app.filesystem.IFileSystemApplication;
import de.intarsys.security.smartcard.card.CardException;
import de.intarsys.security.smartcard.card.CardTools;
import de.intarsys.security.smartcard.card.ICard;
import de.intarsys.security.smartcard.card.ICardConnection;
import de.intarsys.security.smartcard.card.ICardTerminal;
import de.intarsys.security.smartcard.cardterminal.CardTerminalApplicationAdapter;
import de.intarsys.security.smartcard.cardterminal.CommonCardTerminalProduct;
import de.intarsys.security.smartcard.model.CardProductTools;
import de.intarsys.security.smartcard.model.ICardApplication;
import de.intarsys.security.smartcard.model.ICardProduct;
import de.intarsys.security.smartcard.model.IPinInfo;
import de.intarsys.security.smartcard.model.PinInfo;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.security.smartcard.model.app.OperationNotSupported;
import de.intarsys.tools.attribute.Attribute;
import de.intarsys.tools.collection.ByteArrayTools;
import de.intarsys.tools.concurrent.ITaskCallback;
import de.intarsys.tools.concurrent.TaskFailed;
import de.intarsys.tr3110.asn1.CertificateHolderAuthorizationTemplate;
import de.intarsys.tr3110.pace.IPaceApplication;
import de.intarsys.tr3110.pace.PaceInputDataException;
import de.intarsys.tr3110.pace.PaceInputEstablishChannel;
import de.intarsys.tr3110.pace.PaceOutput;
import de.intarsys.tr3110.pace.PaceOutputEstablishChannel;
import de.intarsys.tr3110.pace.PaceTools;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedPaceApplication
extends CardTerminalApplicationAdapter
implements IPaceApplication {
    private static final Logger Log = LoggerFactory.getLogger(EmbeddedPaceApplication.class);
    private static final int CAP_EID = 32;
    private static final int CAP_ESIGN = 16;
    private static final int CAP_PACE = 64;
    private static final int CAP_DESTROY = 128;
    private static final byte FUNC_GetReadersPaceCapabilities = 1;
    private static final byte FUNC_EstablishPaceChannel = 2;
    private static final byte FUNC_DestroyPaceChannel = 3;
    private static final Attribute ATTR_PACE_CHANNELATTRIBUTES = new Attribute("pace_channelAttributes");
    private static final Attribute ATTR_PACE_HELPERCONNECTION = new Attribute("pace_helperConnection");
    public static final String PROP_PACEHELPERCONNECTION = "de.intarsys.tr3110.pace.helperconnection";
    private int readerCapabilities = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void createHelperConnection(ICard card) {
        if (!EmbeddedPaceApplication.isPaceHelperConnectionActive()) {
            return;
        }
        Attribute attribute = ATTR_PACE_HELPERCONNECTION;
        synchronized (attribute) {
            Object connect = card.getCardTerminal().getAttribute((Object)ATTR_PACE_HELPERCONNECTION);
            if (connect == null) {
                Log.info("PACE helper connection connect...");
                connect = CardTools.connectShared((ICard)card, (ITaskCallback)new ITaskCallback<ICardConnection>(){

                    public void failed(TaskFailed exception) {
                        Log.warn("PACE helper connection connect failed (" + exception.getMessage() + ")");
                    }

                    public void finished(ICardConnection connection) {
                        Log.info("PACE helper connection success");
                    }
                });
                card.getCardTerminal().setAttribute((Object)ATTR_PACE_HELPERCONNECTION, connect);
                final ICardTerminal cardTerminal = card.getCardTerminal();
                cardTerminal.addSecondaryResourceFinalizer(new Runnable(){

                    @Override
                    public void run() {
                        EmbeddedPaceApplication.destroyHelperConnection(cardTerminal);
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void destroyHelperConnection(ICardTerminal cardTerminal) {
        Attribute attribute = ATTR_PACE_HELPERCONNECTION;
        synchronized (attribute) {
            block22: {
                Future connect = (Future)cardTerminal.getAttribute((Object)ATTR_PACE_HELPERCONNECTION);
                if (connect == null) {
                    return;
                }
                cardTerminal.setAttribute((Object)ATTR_PACE_HELPERCONNECTION, null);
                if (connect.cancel(true)) {
                    Log.debug("PACE helper connection cancelled");
                    return;
                }
                ICardConnection connection = null;
                try {
                    connection = (ICardConnection)connect.get();
                    IPaceApplication paceApp = PaceTools.getPaceApplication(connection);
                    if (paceApp == null) break block22;
                    Log.debug("PACE helper channel close...");
                    if (paceApp.supportsDestroy()) {
                        paceApp.destroyPaceChannel();
                        Log.debug("PACE helper channel closed");
                        break block22;
                    }
                    PaceInputEstablishChannel input = new PaceInputEstablishChannel();
                    input.setPinInfo(new PinInfo("null", 0, null, null));
                    input.setChat(null);
                    input.setPin(null);
                    input.setCertificateDescription(null);
                    paceApp.establishPaceChannel(input);
                    throw new IllegalStateException("Random PACE channel created");
                }
                catch (PaceInputDataException e) {
                    Log.debug("PACE helper channel closed");
                }
                catch (Exception e) {
                    Log.info("PACE helper channel close failure (" + e.getMessage() + ")");
                }
                finally {
                    try {
                        if (connection != null) {
                            connection.close(0);
                        }
                    }
                    catch (CardException e) {}
                    Log.debug("PACE helper connection closed");
                }
            }
        }
    }

    public static boolean isPaceHelperConnectionActive() {
        return Boolean.parseBoolean(System.getProperty(PROP_PACEHELPERCONNECTION, Boolean.FALSE.toString()));
    }

    private byte[] buildInBuffer(byte fuctionId, byte[] inputData) {
        ByteArrayOutputStream inBuffer = new ByteArrayOutputStream();
        inBuffer.write(fuctionId);
        if (inputData == null || inputData.length == 0) {
            inBuffer.write(new byte[]{0, 0}, 0, 2);
        } else {
            inBuffer.write(ByteArrayTools.toBytesLittleEndian((int)inputData.length, (int)2), 0, 2);
            inBuffer.write(inputData, 0, inputData.length);
        }
        return inBuffer.toByteArray();
    }

    @Override
    public void destroyPaceChannel() throws CardApplicationException {
        this.getCard().setAttribute((Object)ATTR_PACE_CHANNELATTRIBUTES, null);
        this.executePaceFunction((byte)3, null);
    }

    @Override
    public PaceOutputEstablishChannel establishPaceChannel(PaceInputEstablishChannel input) throws CardApplicationException {
        byte[] bytes;
        this.selectCardRoot();
        this.getCard().setAttribute((Object)ATTR_PACE_CHANNELATTRIBUTES, null);
        ByteArrayOutputStream channelArgs = new ByteArrayOutputStream();
        channelArgs.write(input.getPinInfo().getReference());
        if (input.getChat() == null) {
            channelArgs.write(0);
        } else {
            try {
                bytes = input.getChat().getDEREncoded();
            }
            catch (IOException e) {
                throw CardApplicationException.create(e);
            }
            channelArgs.write(bytes.length);
            channelArgs.write(bytes, 0, bytes.length);
        }
        if (input.getPin() == null) {
            channelArgs.write(0);
        } else {
            channelArgs.write(input.getPin().length);
            channelArgs.write(input.getPin(), 0, input.getPin().length);
        }
        if (input.getCertificateDescription() == null) {
            channelArgs.write(0);
            channelArgs.write(0);
        } else {
            channelArgs.write(ByteArrayTools.toBytesLittleEndian((int)input.getCertificateDescription().length, (int)2), 0, 2);
            channelArgs.write(input.getCertificateDescription(), 0, input.getCertificateDescription().length);
        }
        bytes = this.executePaceFunction((byte)2, channelArgs.toByteArray());
        PaceOutputEstablishChannel returnValue = new PaceOutputEstablishChannel(bytes);
        PaceOutput.checkReturnValue(returnValue, this.getCardProduct());
        IPaceApplication.PaceChannelAttributes attributes = new IPaceApplication.PaceChannelAttributes(input.getPinInfo().getReference(), input.getChat());
        this.getCard().setAttribute((Object)ATTR_PACE_CHANNELATTRIBUTES, (Object)attributes);
        EmbeddedPaceApplication.createHelperConnection(this.getCardConnection().getCard());
        return returnValue;
    }

    protected byte[] executePaceFunction(byte fuctionId, byte[] inputData) throws CardApplicationException {
        byte[] outBuffer;
        if (this.getFeatureList().getExecutePace() == 0) {
            throw new OperationNotSupported("PACE not supported");
        }
        byte[] inBuffer = this.buildInBuffer(fuctionId, inputData);
        try {
            outBuffer = this.getCardConnection().control(this.getFeatureList().getExecutePace(), inBuffer, 0, inBuffer.length, 4096);
        }
        catch (CardException e) {
            throw CardApplicationException.create(e);
        }
        return outBuffer;
    }

    protected Class<? extends ICardApplication> getCardApplicationType() {
        return IPaceApplication.class;
    }

    @Override
    public CommonCardTerminalProduct getCardTerminalProduct() {
        return (CommonCardTerminalProduct)super.getCardTerminalProduct();
    }

    public int getReaderPACECapabilities() {
        if (this.readerCapabilities == -1) {
            try {
                byte[] bytes = this.executePaceFunction((byte)1, null);
                PaceOutput returnValue = new PaceOutput(bytes);
                byte[] readerCapData = returnValue.getData();
                this.readerCapabilities = ByteArrayTools.toLittleEndianInt((byte[])readerCapData, (int)0, (int)readerCapData.length);
            }
            catch (Exception e) {
                this.readerCapabilities = 0;
            }
        }
        return this.readerCapabilities;
    }

    @Override
    public void initialize() throws CardApplicationException {
        super.initialize();
        this.setCardProduct(CardProductTools.getCardProduct(this.getCardConnection()));
    }

    @Override
    public boolean isNative() {
        return false;
    }

    @Override
    public boolean isPaceEstablished(IPinInfo pacePinInfo, CertificateHolderAuthorizationTemplate chat) throws CardApplicationException {
        try {
            IPaceApplication.PaceChannelAttributes currentAttributes = (IPaceApplication.PaceChannelAttributes)this.getCard().getAttribute((Object)ATTR_PACE_CHANNELATTRIBUTES);
            IPaceApplication.PaceChannelAttributes newAttributes = new IPaceApplication.PaceChannelAttributes(pacePinInfo.getReference(), chat);
            return newAttributes.equals(currentAttributes);
        }
        catch (Exception e) {
            this.getCard().setAttribute((Object)ATTR_PACE_CHANNELATTRIBUTES, null);
            return false;
        }
    }

    private void selectCardRoot() throws CardApplicationException {
        ICardProduct cardProduct = this.getCardProduct();
        IFileSystemApplication app = cardProduct.createCardApplication(this.getCardConnection(), IFileSystemApplication.class);
        app.selectRoot(false);
    }

    @Override
    public boolean supportsDestroy() {
        return (this.getReaderPACECapabilities() & 0x80) != 0;
    }

    @Override
    public boolean supportsEid() {
        return (this.getReaderPACECapabilities() & 0x20) != 0;
    }

    @Override
    public boolean supportsESign() {
        return (this.getReaderPACECapabilities() & 0x10) != 0;
    }

    @Override
    public boolean supportsPace() throws CardApplicationException {
        boolean supports;
        boolean bl = supports = this.getFeatureList().getExecutePace() != 0;
        if (supports) {
            try {
                return this.getCardTerminalProduct().supportsPace(this.getCardConnection());
            }
            catch (CardApplicationException e) {
                return false;
            }
        }
        return false;
    }

    public boolean supportsPaceFull() {
        return (this.getReaderPACECapabilities() & 0x40) != 0;
    }
}

