/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.cardterminal;

import de.intarsys.security.smartcard.pcsc.nativec._PCSC;
import de.intarsys.tools.reflect.ClassTools;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class FeatureList {
    private final List<Feature> features;

    public FeatureList(byte[] featureList) {
        this.features = new ArrayList<Feature>(featureList.length);
        for (int i = 0; i < featureList.length; i += 6) {
            int id = featureList[i] & 0xFF;
            int code = featureList[i + 5] & 0xFF;
            code |= (featureList[i + 4] & 0xFF) << 8;
            code |= (featureList[i + 3] & 0xFF) << 16;
            this.features.add(new Feature(id, code |= (featureList[i + 2] & 0xFF) << 24));
        }
    }

    public int getCode(int featureId) {
        for (Feature f : this.features) {
            if (f.getId() != featureId) continue;
            return f.getCode();
        }
        return 0;
    }

    public int getExecutePace() {
        return this.getCode(32);
    }

    public int getGetKeyPressed() {
        return this.getCode(5);
    }

    public int getModifyPinDirect() {
        return this.getCode(7);
    }

    public int getModifyPinFinish() {
        return this.getCode(4);
    }

    public int getModifyPinStart() {
        return this.getCode(3);
    }

    public int getVerifyPinDirect() {
        return this.getCode(6);
    }

    public int getVerifyPinFinish() {
        return this.getCode(2);
    }

    public int getVerifyPinStart() {
        return this.getCode(1);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Features: ");
        Iterator<Feature> i = this.features.iterator();
        while (i.hasNext()) {
            Feature f = i.next();
            String name = ClassTools.getConstantName(_PCSC.class, (Object)f.getId());
            if (name != null) {
                builder.append(name);
                builder.append("-");
            }
            builder.append(f.getId());
            builder.append(":");
            builder.append(Integer.toHexString(f.getCode()));
            if (!i.hasNext()) continue;
            builder.append(", ");
        }
        return builder.toString();
    }

    private static class Feature {
        private final int id;
        private final int code;

        public Feature(int pId, int pCode) {
            this.id = pId;
            this.code = pCode;
        }

        public int getCode() {
            return this.code;
        }

        public int getId() {
            return this.id;
        }
    }
}

