/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.cardterminal;

import de.intarsys.security.smartcard.card.ICardConnection;
import de.intarsys.security.smartcard.card.ICardTerminal;
import de.intarsys.security.smartcard.cardterminal.CommonCardTerminalProduct;
import de.intarsys.security.smartcard.common.IPinCodec;
import de.intarsys.tools.bean.BeanComponent;
import de.intarsys.tools.component.ConfigurationException;
import de.intarsys.tools.infoset.ElementTools;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.string.StringTools;
import java.util.regex.Pattern;

@BeanComponent(role="ICardTerminalProduct")
public class GenericCardTerminalProduct
extends CommonCardTerminalProduct {
    private String name;
    private String vendor;
    private Pattern pattern;

    @Override
    public boolean accept(ICardConnection connection) {
        if (this.pattern == null) {
            return true;
        }
        ICardTerminal terminal = connection.getCardTerminal();
        String terminalName = terminal.getName();
        return this.pattern.matcher(terminalName).matches();
    }

    @Override
    public void configure(IElement element) throws ConfigurationException {
        super.configure(element);
        this.setName(ElementTools.getString((IElement)element, (String)"name", (String)this.getName()));
        this.setVendor(ElementTools.getString((IElement)element, (String)"vendor", (String)this.getVendor()));
        String patternString = ElementTools.getString((IElement)element, (String)"pattern", (String)"");
        if (!StringTools.isEmpty((String)patternString)) {
            this.pattern = Pattern.compile(patternString);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    @Override
    public String getVendor() {
        return this.vendor == null ? "unknown" : this.vendor;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPattern(Pattern pattern) {
        this.pattern = pattern;
    }

    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    @Override
    public boolean supportsPinModify(IPinCodec pinCodec) {
        if ("BCD".equals(pinCodec.getType())) {
            return false;
        }
        return super.supportsPinModify(pinCodec);
    }
}

