/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.cardterminal;

import de.intarsys.security.smartcard.card.ICardConnection;
import de.intarsys.security.smartcard.card.ICardTerminal;
import de.intarsys.security.smartcard.cardterminal.CommonCardTerminalProduct;
import de.intarsys.security.smartcard.common.IPinCodec;
import de.intarsys.security.smartcard.pcsc.nativec.PIN_MODIFY_STRUCTURE;
import de.intarsys.tools.bean.BeanComponent;

@BeanComponent(role="ICardTerminalProduct")
public class Kobil
extends CommonCardTerminalProduct {
    @Override
    public boolean accept(ICardConnection connection) {
        ICardTerminal terminal = connection.getCardTerminal();
        String name = terminal.getName().toLowerCase();
        return name.contains("kobil");
    }

    @Override
    protected PIN_MODIFY_STRUCTURE applyCardReaderFixes(IPinCodec pinCodec, PIN_MODIFY_STRUCTURE modifyStr, boolean enterCurrentPIN) {
        if ("Format2".equals(pinCodec.getType())) {
            modifyStr.setInsertionOffsetOld(1);
            modifyStr.setInsertionOffsetNew(9);
        }
        return modifyStr;
    }

    @Override
    public String getVendor() {
        return "Kobil";
    }

    @Override
    protected boolean isLockDirect() {
        return true;
    }

    @Override
    public boolean supportsPinModify(IPinCodec pinCodec) {
        if ("BCD".equals(pinCodec.getType())) {
            return false;
        }
        return super.supportsPinModify(pinCodec);
    }
}

