/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.cardterminal;

import de.intarsys.security.smartcard.card.ICardConnection;
import de.intarsys.security.smartcard.card.ICardTerminal;
import de.intarsys.security.smartcard.cardterminal.CommonCardTerminalProduct;
import de.intarsys.security.smartcard.common.IPinCodec;
import de.intarsys.tools.bean.BeanComponent;
import de.intarsys.tools.system.SystemTools;

@BeanComponent(role="ICardTerminalProduct")
public class Omnikey
extends CommonCardTerminalProduct {
    @Override
    public boolean accept(ICardConnection connection) {
        ICardTerminal terminal = connection.getCardTerminal();
        String name = terminal.getName().toLowerCase();
        return name.contains("omnikey");
    }

    @Override
    public String getVendor() {
        return "Omnikey";
    }

    @Override
    public boolean supportsPinModify(IPinCodec pinCodec) {
        if ("BCD".equals(pinCodec.getType())) {
            return false;
        }
        if ((SystemTools.isLinux() || SystemTools.isMac()) && "Ascii".equals(pinCodec.getType())) {
            return false;
        }
        return super.supportsPinModify(pinCodec);
    }
}

