/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.cardterminal;

import de.intarsys.security.smartcard.card.CardException;
import de.intarsys.security.smartcard.card.RequestAPDU;
import de.intarsys.security.smartcard.card.ResponseAPDU;
import de.intarsys.security.smartcard.cardterminal.CardTerminalApplicationAdapter;
import de.intarsys.security.smartcard.cardterminal.CommonCardTerminalProduct;
import de.intarsys.security.smartcard.cardterminal.IPinEntryApplication;
import de.intarsys.security.smartcard.cardterminal.PinPadEvent;
import de.intarsys.security.smartcard.common.IPinCodec;
import de.intarsys.security.smartcard.model.CardResponseHandler;
import de.intarsys.security.smartcard.model.ICardApplication;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.security.smartcard.model.app.CardAuthenticationCanceledException;
import de.intarsys.security.smartcard.model.app.CardAuthenticationFailedException;
import de.intarsys.security.smartcard.model.app.CardAuthenticationTimeout;
import de.intarsys.security.smartcard.model.app.CardStatusCodeException;
import de.intarsys.security.smartcard.pcsc.nativec.PIN_MODIFY_STRUCTURE;
import de.intarsys.security.smartcard.pcsc.nativec.PIN_VERIFY_STRUCTURE;
import de.intarsys.tools.event.Event;
import de.intarsys.tools.event.EventDispatcher;
import de.intarsys.tools.event.EventType;
import de.intarsys.tools.event.INotificationListener;
import de.intarsys.tools.message.IMessage;
import de.intarsys.tools.message.LiteralMessage;
import de.intarsys.tools.progress.IProgressMonitor;
import de.intarsys.tools.reporter.Reporter;

public class PinEntryApplication
extends CardTerminalApplicationAdapter
implements IPinEntryApplication {
    private static CardResponseHandler cardResponseHandler = new CardResponseHandler();
    private final EventDispatcher eventDispatcher = new EventDispatcher((Object)this);
    private int timeout;
    private int timeoutKeyPress;
    private boolean lockDirect;

    public void addNotificationListener(EventType type, INotificationListener listener) {
        this.eventDispatcher.addNotificationListener(type, listener);
    }

    protected void generateKeyEvents(IProgressMonitor monitor, IMessage[] messages, int pinCount) throws CardException {
        if (this.getFeatureList().getGetKeyPressed() == 0) {
            return;
        }
        int currentPinSize = 0;
        int currentPinNumber = 0;
        byte[] keyResponse = this.getCardConnection().control(this.getFeatureList().getGetKeyPressed(), null, 0, 0, 1);
        this.reportProgress(monitor, messages, currentPinNumber, currentPinSize, 0.0f);
        while (keyResponse.length > 0) {
            switch (keyResponse[0]) {
                case 0: {
                    break;
                }
                case 8: {
                    if (currentPinSize > 0) {
                        --currentPinSize;
                    }
                    this.eventDispatcher.handleEvent((Event)new PinPadEvent(this, "backspacePressed"));
                    this.reportProgress(monitor, messages, currentPinNumber, currentPinSize, -1.0f);
                    break;
                }
                case 10: {
                    this.reportProgress(monitor, messages, currentPinNumber, currentPinSize, -currentPinSize);
                    currentPinSize = 0;
                    this.eventDispatcher.handleEvent((Event)new PinPadEvent(this, "allKeysCleared"));
                    break;
                }
                case 13: {
                    currentPinSize = 0;
                    this.eventDispatcher.handleEvent((Event)new PinPadEvent(this, "enterPressed"));
                    this.reportProgress(monitor, messages, ++currentPinNumber, currentPinSize, 1.0f);
                    if (currentPinNumber < pinCount) break;
                    return;
                }
                case 14: {
                    this.eventDispatcher.handleEvent((Event)new PinPadEvent(this, "finishedByTimeout"));
                    return;
                }
                case 27: {
                    this.eventDispatcher.handleEvent((Event)new PinPadEvent(this, "cancelPressed"));
                    return;
                }
                case 43: {
                    this.eventDispatcher.handleEvent((Event)new PinPadEvent(this, "keyPressed"));
                    this.reportProgress(monitor, messages, currentPinNumber, ++currentPinSize, 1.0f);
                    break;
                }
                case 64: {
                    return;
                }
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
            keyResponse = this.getCardConnection().control(this.getFeatureList().getGetKeyPressed(), null, 0, 0, 1);
        }
    }

    protected Class<? extends ICardApplication> getCardApplicationType() {
        return IPinEntryApplication.class;
    }

    @Override
    public CommonCardTerminalProduct getCardTerminalProduct() {
        return (CommonCardTerminalProduct)super.getCardTerminalProduct();
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getTimeoutKeyPress() {
        return this.timeoutKeyPress;
    }

    public boolean isLockDirect() {
        return this.lockDirect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] modifyRequestDirect(PIN_MODIFY_STRUCTURE modifyStr, IMessage[] messages) throws CardException {
        byte[] response;
        IMessage msg = messages == null || messages.length == 0 ? LiteralMessage.create((String)"PinEntryApp.activity.enterPin", (String)"Enter PIN", (Object[])new Object[0]) : messages[0];
        IProgressMonitor monitor = Reporter.get().reportActivityStart(msg, 3);
        try {
            response = this.getCardConnection().control(this.getFeatureList().getModifyPinDirect(), modifyStr.getBytes(), 0, modifyStr.getByteCount(), 32);
        }
        finally {
            monitor.end();
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] modifyRequestIndirect(PIN_MODIFY_STRUCTURE modifyStr, IMessage[] messages, boolean enterCurrentPIN) throws CardException {
        IMessage msg = messages == null || messages.length == 0 ? LiteralMessage.create((String)"PinEntryApp.activity.enterPin", (String)"Enter PIN", (Object[])new Object[0]) : messages[0];
        int pinCount = enterCurrentPIN ? 3 : 2;
        int maxChars = modifyStr.getPINMaxExtraDigit() & 0xFF;
        IProgressMonitor monitor = Reporter.get().reportActivityStart(msg, 3);
        monitor.begin("", (float)maxChars);
        try {
            this.getCardConnection().control(this.getFeatureList().getModifyPinStart(), modifyStr.getBytes(), 0, modifyStr.getByteCount(), 32);
            this.generateKeyEvents(monitor, messages, pinCount);
            byte[] byArray = this.getCardConnection().control(this.getFeatureList().getModifyPinFinish(), null, 0, 0, 32);
            return byArray;
        }
        finally {
            monitor.end();
        }
    }

    public void removeNotificationListener(EventType type, INotificationListener listener) {
        this.eventDispatcher.removeNotificationListener(type, listener);
    }

    protected void reportProgress(IProgressMonitor monitor, IMessage[] messages, int msgIndex, int currentPinSize, float amount) {
        if (messages != null && msgIndex >= messages.length) {
            msgIndex = messages.length - 1;
        }
        StringBuilder sb = new StringBuilder();
        sb.append((Object)(messages == null ? "Enter PIN" : messages[msgIndex]));
        sb.append("\n\n");
        for (int i = 0; i < currentPinSize; ++i) {
            sb.append("\u25cf");
        }
        monitor.subTask(sb.toString());
        monitor.worked(amount);
    }

    @Override
    public ResponseAPDU sendModifyRequest(RequestAPDU apdu, IPinCodec pinCodec, boolean enterCurrentPIN, IMessage[] messages) throws CardApplicationException {
        if (!this.supportsPinModify(pinCodec)) {
            throw new CardApplicationException(pinCodec.toString() + " not supported");
        }
        if (messages == null) {
            messages = this.getCardTerminalProduct().getModifyInstructions(this.getCardTerminal());
        }
        PIN_MODIFY_STRUCTURE modifyStr = this.getCardTerminalProduct().createPINModifyStructure(apdu, pinCodec, enterCurrentPIN, this.getTimeout(), this.getTimeoutKeyPress());
        try {
            byte[] response = this.supportsPinModifyIndirect(pinCodec) ? this.modifyRequestIndirect(modifyStr, messages, enterCurrentPIN) : this.modifyRequestDirect(modifyStr, messages);
            ResponseAPDU resp = new ResponseAPDU(response);
            cardResponseHandler.checkResponse(apdu, resp);
            return resp;
        }
        catch (CardException e) {
            throw CardApplicationException.create(e);
        }
    }

    @Override
    public ResponseAPDU sendVerifyRequest(RequestAPDU apdu, IPinCodec pinCodec, IMessage msg) throws CardApplicationException {
        if (!this.supportsPinVerify(pinCodec)) {
            throw new CardApplicationException(pinCodec.toString() + " not supported");
        }
        PIN_VERIFY_STRUCTURE verifyStr = this.getCardTerminalProduct().createPINVerifyStructure(apdu, pinCodec, this.getTimeout(), this.getTimeoutKeyPress());
        try {
            byte[] response = this.supportsPinVerifyIndirect(pinCodec) ? this.verifyPinIndirect(verifyStr, msg) : this.verifyPinDirect(verifyStr, msg);
            ResponseAPDU resp = new ResponseAPDU(response);
            cardResponseHandler.checkResponse(apdu, resp);
            return resp;
        }
        catch (CardException e) {
            throw CardApplicationException.create(e);
        }
    }

    public void setLockDirect(boolean lockDirect) {
        this.lockDirect = lockDirect;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public void setTimeoutKeyPress(int timeoutKeyPress) {
        this.timeoutKeyPress = timeoutKeyPress;
    }

    @Override
    public boolean supportsPinModify(IPinCodec pinCodec) {
        return this.supportsPinModifyDirect(pinCodec) || this.supportsPinModifyIndirect(pinCodec);
    }

    @Override
    public boolean supportsPinModifyDirect(IPinCodec pinCodec) {
        boolean supports;
        boolean bl = supports = this.getFeatureList().getModifyPinDirect() != 0;
        if (supports) {
            return this.getCardTerminalProduct().supportsPinModify(pinCodec);
        }
        return false;
    }

    @Override
    public boolean supportsPinModifyIndirect(IPinCodec pinCodec) {
        boolean supports;
        if (this.isLockDirect()) {
            return false;
        }
        boolean bl = supports = this.getFeatureList().getModifyPinStart() != 0 && this.getFeatureList().getModifyPinFinish() != 0 && this.getFeatureList().getGetKeyPressed() != 0;
        if (supports) {
            return this.getCardTerminalProduct().supportsPinModify(pinCodec);
        }
        return false;
    }

    @Override
    public boolean supportsPinVerify(IPinCodec pinCodec) {
        return this.supportsPinVerifyDirect(pinCodec) || this.supportsPinVerifyIndirect(pinCodec);
    }

    @Override
    public boolean supportsPinVerifyDirect(IPinCodec pinCodec) {
        boolean supports;
        boolean bl = supports = this.getFeatureList().getVerifyPinDirect() != 0;
        if (supports) {
            return this.getCardTerminalProduct().supportsPinVerify(pinCodec);
        }
        return false;
    }

    @Override
    public boolean supportsPinVerifyIndirect(IPinCodec pinCodec) {
        boolean supports;
        if (this.isLockDirect()) {
            return false;
        }
        boolean bl = supports = this.getFeatureList().getVerifyPinStart() != 0 && this.getFeatureList().getVerifyPinFinish() != 0 && this.getFeatureList().getGetKeyPressed() != 0;
        if (supports) {
            return this.getCardTerminalProduct().supportsPinVerify(pinCodec);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] verifyPinDirect(PIN_VERIFY_STRUCTURE verifyStr, IMessage msg) throws CardException {
        IProgressMonitor monitor = Reporter.get().reportActivityStart(msg, 3);
        try {
            byte[] byArray = this.getCardConnection().control(this.getFeatureList().getVerifyPinDirect(), verifyStr.getBytes(), 0, verifyStr.getByteCount(), 32);
            return byArray;
        }
        finally {
            monitor.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] verifyPinIndirect(PIN_VERIFY_STRUCTURE verifyStr, IMessage msg) throws CardException {
        int maxChars = verifyStr.getPINMaxExtraDigit() & 0xFF;
        IProgressMonitor monitor = Reporter.get().reportActivityStart(msg, 3);
        monitor.begin("", (float)maxChars);
        try {
            this.getCardConnection().control(this.getFeatureList().getVerifyPinStart(), verifyStr.getBytes(), 0, verifyStr.getByteCount(), 32);
            this.generateKeyEvents(monitor, new IMessage[]{msg}, 1);
            byte[] byArray = this.getCardConnection().control(this.getFeatureList().getVerifyPinFinish(), null, 0, 0, 32);
            return byArray;
        }
        finally {
            monitor.end();
        }
    }

    static {
        cardResponseHandler.addResponseMap("*", "*", "*", null, null);
        cardResponseHandler.addResponseMap("*", "64", "0", CardAuthenticationTimeout.class, null);
        cardResponseHandler.addResponseMap("*", "64", "1", CardAuthenticationCanceledException.class, null);
        cardResponseHandler.addResponseMap("*", "64", "2", CardAuthenticationFailedException.class, null);
        cardResponseHandler.addResponseMap("*", "64", "3", CardAuthenticationFailedException.class, null);
        cardResponseHandler.addResponseMap("*", "6b", "80", CardStatusCodeException.class, "invalid parameter in structure");
    }
}

