/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.cardterminal;

import de.intarsys.security.smartcard.card.ICardConnection;
import de.intarsys.security.smartcard.card.ICardTerminal;
import de.intarsys.security.smartcard.cardterminal.CardTerminalTools;
import de.intarsys.security.smartcard.cardterminal.CommonCardTerminalProduct;
import de.intarsys.security.smartcard.cardterminal.EIDCardTerminalStateApplication;
import de.intarsys.security.smartcard.cardterminal.ICardTerminalStateApplication;
import de.intarsys.security.smartcard.common.IPinCodec;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.security.smartcard.pcsc.nativec.PIN_MODIFY_STRUCTURE;
import de.intarsys.security.smartcard.pcsc.nativec.PIN_VERIFY_STRUCTURE;
import de.intarsys.tools.bean.BeanComponent;

@BeanComponent(role="ICardTerminalProduct")
public class ReinerSct
extends CommonCardTerminalProduct {
    @Override
    public boolean accept(ICardConnection connection) {
        ICardTerminal terminal = connection.getCardTerminal();
        String name = terminal.getName().toLowerCase();
        return name.contains("reiner") || name.contains("cyberjack");
    }

    @Override
    protected PIN_MODIFY_STRUCTURE applyCardReaderFixes(IPinCodec pinCodec, PIN_MODIFY_STRUCTURE modifyStr, boolean enterCurrentPIN) {
        if (pinCodec.getMaxCharacters() > 15) {
            modifyStr.setPINMaxExtraDigit(pinCodec.getMinCharacters(), 15);
        }
        return modifyStr;
    }

    @Override
    protected PIN_VERIFY_STRUCTURE applyCardReaderFixes(IPinCodec pinCodec, PIN_VERIFY_STRUCTURE verifyStr) {
        if (pinCodec.getMaxCharacters() > 15) {
            verifyStr.setPINMaxExtraDigit(pinCodec.getMinCharacters(), 15);
        }
        return verifyStr;
    }

    @Override
    protected ICardTerminalStateApplication createStateApplication(ICardConnection connection) throws CardApplicationException {
        if (CardTerminalTools.getFeatureList(connection).getExecutePace() == 0) {
            return super.createStateApplication(connection);
        }
        EIDCardTerminalStateApplication tsa = new EIDCardTerminalStateApplication();
        tsa.setCardTerminalProduct(this);
        tsa.setCardConnection(connection);
        tsa.initialize();
        return tsa;
    }

    @Override
    public String getVendor() {
        return "Reiner SCT";
    }

    @Override
    public boolean supportsPinModify(IPinCodec pinCodec) {
        if (pinCodec.getMinCharacters() > 15) {
            return false;
        }
        if ("BCD".equals(pinCodec.getType())) {
            return false;
        }
        return super.supportsPinModify(pinCodec);
    }

    @Override
    public boolean supportsPinVerify(IPinCodec pinCodec) {
        if (pinCodec.getMinCharacters() > 15) {
            return false;
        }
        return super.supportsPinVerify(pinCodec);
    }
}

