/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.cardterminal;

import de.intarsys.security.smartcard.card.CardException;
import de.intarsys.security.smartcard.card.ICardConnection;
import de.intarsys.security.smartcard.card.ICardTerminal;
import de.intarsys.security.smartcard.cardterminal.AttributeReader;
import de.intarsys.security.smartcard.cardterminal.CardTerminalStateApplication;
import de.intarsys.security.smartcard.cardterminal.CommonCardTerminalProduct;
import de.intarsys.security.smartcard.cardterminal.ICardTerminalStateApplication;
import de.intarsys.security.smartcard.common.IPinCodec;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.tools.bean.BeanComponent;
import de.intarsys.tools.collection.ByteArrayTools;
import de.intarsys.tools.system.SystemTools;

@BeanComponent(role="ICardTerminalProduct")
public class St2000
extends CommonCardTerminalProduct {
    private static final int SCARD_CTL_READVERSION = 2049;

    public static int getFirmwareVersion(ICardConnection channel) {
        try {
            byte[] versionControl = St2000.readVersionControl(channel);
            return St2000.parseFirmwareVersion(versionControl);
        }
        catch (CardException e) {
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getFirmwareVersion(ICardTerminal cardTerminal) {
        ICardConnection connection = null;
        try {
            connection = cardTerminal.connectDirect();
            int n = St2000.getFirmwareVersion(connection);
            return n;
        }
        catch (CardException e) {
            int n = -1;
            return n;
        }
        finally {
            if (connection != null) {
                try {
                    connection.close(0);
                }
                catch (CardException cardException) {}
            }
        }
    }

    static int parseFirmwareVersion(byte[] versionControl) {
        if (versionControl.length < 8) {
            return -1;
        }
        return ByteArrayTools.toBigEndianIntUnsigned((byte[])versionControl, (int)6, (int)2);
    }

    static byte[] readVersionControl(ICardConnection channel) throws CardException {
        return channel.controlMapped(2049, null, 0, 0, 256);
    }

    @Override
    public boolean accept(ICardConnection connection) {
        ICardTerminal terminal = connection.getCardTerminal();
        String name = terminal.getName().toLowerCase();
        return name.contains("st-2xxx");
    }

    @Override
    protected ICardTerminalStateApplication createStateApplication(ICardConnection connection) throws CardApplicationException {
        CardTerminalStateApplication app = new CardTerminalStateApplication(){

            @Override
            protected String readFirmwareVersion(AttributeReader attrReader) {
                return Integer.toHexString(St2000.getFirmwareVersion(this.getCardConnection()));
            }
        };
        app.setCardTerminalProduct(this);
        app.setCardConnection(connection);
        app.initialize();
        return app;
    }

    @Override
    public String getName() {
        return "ST2000";
    }

    @Override
    public String getVendor() {
        return "Cherry";
    }

    @Override
    public boolean supportsPinModify(IPinCodec pinCodec) {
        if ("BCD".equals(pinCodec.getType())) {
            return false;
        }
        if (SystemTools.isLinux() || SystemTools.isMac()) {
            return false;
        }
        return super.supportsPinModify(pinCodec);
    }
}

