/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.certificate;

import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.filter.IServiceTypeSelector;
import de.intarsys.security.certificate.filter.IX509CertificateFilter;
import de.intarsys.security.certificate.filter.IX509CertificateSelector;
import de.intarsys.security.certificate.filter.standard.X509CertificateSelectorIdentity;
import de.intarsys.security.certificate.provider.ICertificateProvider;
import de.intarsys.security.smartcard.app.filesystem.CardFileSelector;
import de.intarsys.security.smartcard.card.CardSystem;
import de.intarsys.security.smartcard.card.ICard;
import de.intarsys.security.smartcard.card.ICardSystem;
import de.intarsys.security.smartcard.card.ICardTerminal;
import de.intarsys.security.smartcard.model.CardCertificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;

public class ActiveCardCertificateProvider
implements ICertificateProvider {
    public boolean containsCertificate(IX509Certificate certificate) {
        X509CertificateSelectorIdentity selector = new X509CertificateSelectorIdentity(certificate);
        Iterator<IX509Certificate> certificates = this.lookupCertificates((IX509CertificateFilter)selector);
        return certificates.hasNext();
    }

    public Iterator<IX509Certificate> lookupCertificates(IX509CertificateFilter filter) {
        if (filter instanceof IX509CertificateSelector) {
            IX509CertificateSelector selector = (IX509CertificateSelector)filter;
            if (selector.hasPrivateKey() != null) {
                // empty if block
            }
            if (Boolean.TRUE.equals(selector.isPrivateKeyAccessible())) {
                return Collections.emptyIterator();
            }
            IServiceTypeSelector serviceTypeSelector = selector.getServiceTypeSelector();
            if (serviceTypeSelector != null && serviceTypeSelector.isTrustedOnly()) {
                return Collections.emptyIterator();
            }
        }
        ArrayList<IX509Certificate> result = new ArrayList<IX509Certificate>();
        ICardSystem cardSystem = CardSystem.get();
        for (ICardTerminal terminal : cardSystem.getCardTerminals()) {
            ICard card = terminal.getCard();
            if (card == null || card.getState().isInvalid()) continue;
            Map<CardFileSelector, CardCertificate> certs = CardCertificate.getCardCertificates(card);
            for (IX509Certificate iX509Certificate : certs.values()) {
                if (filter != null && !filter.accept(iX509Certificate)) continue;
                result.add(iX509Certificate);
            }
        }
        return result.iterator();
    }
}

