/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.certificate;

import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.filter.IServiceTypeSelector;
import de.intarsys.security.certificate.filter.IX509CertificateFilter;
import de.intarsys.security.certificate.filter.IX509CertificateSelector;
import de.intarsys.security.certificate.provider.ICertificateProvider;
import de.intarsys.security.smartcard.app.common.IAuthenticateApplication;
import de.intarsys.security.smartcard.app.common.IDecryptApplication;
import de.intarsys.security.smartcard.app.common.ISignApplication;
import de.intarsys.security.smartcard.certificate.CommonSmartcardCertificateProvider;
import de.intarsys.security.smartcard.model.CardCertificate;
import de.intarsys.security.smartcard.model.app.CardHolderCertificateDetector;
import de.intarsys.tools.collection.ConversionIterator;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class SmartcardAllCertificateProvider
extends CommonSmartcardCertificateProvider {
    public Iterator<IX509Certificate> lookupCertificates(IX509CertificateFilter filter) {
        Class appClass = null;
        if (filter instanceof IX509CertificateSelector) {
            IX509CertificateSelector selector = (IX509CertificateSelector)filter;
            if (selector.hasPrivateKey() != null) {
                // empty if block
            }
            if (Boolean.TRUE.equals(selector.isPrivateKeyAccessible())) {
                return Collections.emptyIterator();
            }
            IServiceTypeSelector serviceTypeSelector = selector.getServiceTypeSelector();
            if (serviceTypeSelector != null && serviceTypeSelector.isTrustedOnly()) {
                return Collections.emptyIterator();
            }
            String app = selector.getSecurityApplication();
            if ("signature".equals(app)) {
                appClass = ISignApplication.class;
            } else if ("decryption".equals(app)) {
                appClass = IDecryptApplication.class;
            } else if ("authentication".equals(app)) {
                appClass = IAuthenticateApplication.class;
            }
        }
        if (appClass == null) {
            return Collections.emptyIterator();
        }
        CardHolderCertificateDetector searcher = new CardHolderCertificateDetector(appClass);
        searcher.setCertificateFilter(filter);
        List results = searcher.findAll();
        return new ConversionIterator<CardHolderCertificateDetector.Result, IX509Certificate>(results.iterator()){

            protected IX509Certificate createTargetObject(CardHolderCertificateDetector.Result sourceObject) {
                CardCertificate certificate = (CardCertificate)((Object)sourceObject.getCardHolderCertificate());
                certificate.setCertificateProvider((ICertificateProvider)SmartcardAllCertificateProvider.this);
                return certificate;
            }
        };
    }
}

