/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.certificate;

import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.certificate.filter.IX509CertificateFilter;
import de.intarsys.security.certificate.provider.ICertificateProvider;
import de.intarsys.security.smartcard.certificate.AxSelectSmartcardCertificate;
import de.intarsys.security.smartcard.certificate.CommonSmartcardCertificateProvider;
import de.intarsys.security.smartcard.model.CardCertificate;
import de.intarsys.security.smartcard.model.ICardApplication;
import de.intarsys.security.smartcard.model.ICardHolderCertificate;
import de.intarsys.security.smartcard.model.app.CardHolderCertificateDetector;
import de.intarsys.tools.activity.RequestConfirmation;
import de.intarsys.tools.collection.SingleObjectIterator;
import de.intarsys.tools.message.IMessage;
import de.intarsys.tools.message.LiteralMessage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SmartcardSelectCertificateProvider
extends CommonSmartcardCertificateProvider {
    private Class<?> securityApplication = null;
    private String cardTerminal;
    private boolean closeConnections = true;
    private boolean selectionInteractive = false;
    private Map<IX509Certificate, CardCertificateState> certificateStates = new HashMap<IX509Certificate, CardCertificateState>();
    private boolean selectionUnique = false;

    protected IX509Certificate createCertificate(CardHolderCertificateDetector.Result result) {
        ICardHolderCertificate certificate = result.getCardHolderCertificate();
        CardCertificateState cardCertificateState = new CardCertificateState(result.getCardHolderCertificate(), (ICardApplication)result.getApplication());
        this.certificateStates.put(certificate, cardCertificateState);
        if (certificate instanceof CardCertificate) {
            CardCertificate deferred = (CardCertificate)((Object)certificate);
            deferred.setCertificateProvider((ICertificateProvider)this);
        }
        return certificate;
    }

    public ICardApplication getCardApplication(IX509Certificate certificate) {
        CardCertificateState cardCertificateState = this.certificateStates.get(certificate);
        if (cardCertificateState == null) {
            return null;
        }
        return cardCertificateState.getCardApplication();
    }

    public ICardHolderCertificate getCardHolderCertificate(IX509Certificate certificate) {
        CardCertificateState cardCertificateState = this.certificateStates.get(certificate);
        if (cardCertificateState == null) {
            return null;
        }
        return cardCertificateState.getCardHolderCertificate();
    }

    public String getCardTerminal() {
        return this.cardTerminal;
    }

    public Class<?> getSecurityApplication() {
        return this.securityApplication;
    }

    public boolean isCloseConnections() {
        return this.closeConnections;
    }

    public boolean isSelectionInteractive() {
        return this.selectionInteractive;
    }

    public boolean isSelectionUnique() {
        return this.selectionUnique;
    }

    public Iterator<IX509Certificate> lookupCertificates(IX509CertificateFilter filter) {
        block11: {
            IMessage message;
            IMessage title;
            IMessage response;
            if (this.getSecurityApplication() == null) {
                return Collections.emptyIterator();
            }
            do {
                List<CardHolderCertificateDetector.Result> results;
                if (!(results = this.lookupResults(filter)).isEmpty()) {
                    CardHolderCertificateDetector.Result result = null;
                    if (this.isSelectionInteractive() && results.size() > 1) {
                        ArrayList certificates = new ArrayList();
                        for (CardHolderCertificateDetector.Result temp : results) {
                            certificates.add(temp.getCardHolderCertificate());
                        }
                        IX509PublicKeyCertificate certificate = AxSelectSmartcardCertificate.select(certificates);
                        for (CardHolderCertificateDetector.Result temp : results) {
                            if (temp.getCardHolderCertificate() != certificate) continue;
                            result = temp;
                        }
                    } else {
                        result = results.size() > 1 && this.isSelectionUnique() ? null : results.get(0);
                    }
                    for (CardHolderCertificateDetector.Result temp : results) {
                        if (result != null && temp.getCardConnection() == result.getCardConnection()) continue;
                        try {
                            temp.getCardConnection().close(0);
                        }
                        catch (Exception exception) {}
                    }
                    if (result == null) {
                        return Collections.emptyIterator();
                    }
                    return new SingleObjectIterator((Object)this.createCertificate(result));
                }
                if (!this.isSelectionInteractive()) break block11;
            } while ((response = RequestConfirmation.requestConfirm(null, (IMessage)(title = LiteralMessage.create((String)"Kein Zertifikat gefunden")), (IMessage)(message = LiteralMessage.create((String)"Legen Sie eine geeignete Signaturkarte ein")), (IMessage)RequestConfirmation.OPTION_OK)) == RequestConfirmation.OPTION_OK);
            return Collections.emptyIterator();
        }
        return Collections.emptyIterator();
    }

    protected List<CardHolderCertificateDetector.Result> lookupResults(IX509CertificateFilter filter) {
        CardHolderCertificateDetector searcher = new CardHolderCertificateDetector(this.getSecurityApplication());
        searcher.addCardTerminal(this.getCardTerminal());
        searcher.setCloseConnection(this.isCloseConnections());
        searcher.setCertificateFilter(filter);
        return searcher.findAll();
    }

    public void setCardTerminal(String cardTerminal) {
        this.cardTerminal = cardTerminal;
    }

    public void setCloseConnections(boolean closeConnections) {
        this.closeConnections = closeConnections;
    }

    public void setSecurityApplication(Class<?> securityApplication) {
        this.securityApplication = securityApplication;
    }

    public void setSelectionInteractive(boolean interactive) {
        this.selectionInteractive = interactive;
    }

    public void setSelectionUnique(boolean uniqueSelectionRequired) {
        this.selectionUnique = uniqueSelectionRequired;
    }

    private static class CardCertificateState {
        private final ICardHolderCertificate cardHolderCertificate;
        private final ICardApplication cardApplication;

        public CardCertificateState(ICardHolderCertificate cardHolderCertificate, ICardApplication cardApplication) {
            this.cardHolderCertificate = cardHolderCertificate;
            this.cardApplication = cardApplication;
        }

        public ICardApplication getCardApplication() {
            return this.cardApplication;
        }

        public ICardHolderCertificate getCardHolderCertificate() {
            return this.cardHolderCertificate;
        }
    }
}

