/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.common;

import de.intarsys.security.smartcard.common.IPinCodec;
import java.util.Arrays;

public abstract class CommonPinCodec
implements IPinCodec {
    private byte padCharacter;
    private int minCharacters;
    private int maxCharacters;
    private int blockSize = 0;
    private Integer insertionOffsetNew;

    protected CommonPinCodec(byte pPadCharacter, int pMinCharacters, int pMaxCharacters, int pBlockSize) {
        this.padCharacter = pPadCharacter;
        this.minCharacters = pMinCharacters;
        this.maxCharacters = pMaxCharacters;
        this.blockSize = pBlockSize;
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
    }

    @Override
    public int getBlockSize() {
        return this.blockSize;
    }

    @Override
    public int getInsertionOffsetNew(boolean currentPinEntered) {
        if (this.insertionOffsetNew != null) {
            return this.insertionOffsetNew;
        }
        if (currentPinEntered) {
            return this.getBlockSize();
        }
        return 0;
    }

    @Override
    public int getMaxCharacters() {
        return this.maxCharacters;
    }

    @Override
    public int getMinCharacters() {
        return this.minCharacters;
    }

    @Override
    public int getOffsetForVerify() {
        return 5;
    }

    @Override
    public byte getPadCharacter() {
        return this.padCharacter;
    }

    @Override
    public int getPinBlockPinSize() {
        return this.getBlockSize();
    }

    @Override
    public byte[] getTemplate() {
        byte[] template = new byte[this.getBlockSize()];
        Arrays.fill(template, this.getPadCharacter());
        return template;
    }

    public void setBlockSize(int blockSize) {
        this.blockSize = blockSize;
    }

    public void setInsertionOffsetNew(int pInsertionOffsetNew) {
        this.insertionOffsetNew = pInsertionOffsetNew;
    }

    public void setMaxCharacters(int maxCharacters) {
        this.maxCharacters = maxCharacters;
    }

    public void setMinCharacters(int minCharacters) {
        this.minCharacters = minCharacters;
    }

    public void setPadCharacter(byte padCharacter) {
        this.padCharacter = padCharacter;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getType());
        builder.append("; min: ");
        builder.append(this.getMinCharacters());
        builder.append("; max: ");
        builder.append(this.getMaxCharacters());
        if (this.getBlockSize() != 0) {
            builder.append("; blockSize: ");
            builder.append(this.getBlockSize());
        }
        return builder.toString();
    }
}

