/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.common;

import de.intarsys.security.smartcard.common.CommonPinCodec;

public class PinCodecAscii
extends CommonPinCodec {
    private static final int BLOCK_SIZE = 0;

    public PinCodecAscii(int padCharacter, int minCharacters, int maxCharacters) {
        super((byte)padCharacter, minCharacters, maxCharacters, 0);
    }

    @Override
    public byte[] encode(char[] pin) {
        int i;
        int length;
        int i2;
        int start = pin.length;
        int end = -1;
        for (i2 = 0; i2 < pin.length; ++i2) {
            if (Character.isWhitespace(pin[i2])) continue;
            start = i2;
            break;
        }
        for (i2 = pin.length - 1; i2 >= 0; --i2) {
            if (Character.isWhitespace(pin[i2])) continue;
            end = i2;
            break;
        }
        if ((length = end - start + 1) < this.getMinCharacters()) {
            length = this.getMinCharacters();
        }
        if (length < this.getBlockSize()) {
            length = this.getBlockSize();
        }
        byte[] result = new byte[length];
        for (i = start; i <= end; ++i) {
            result[i - start] = (byte)pin[i];
        }
        while (i < result.length) {
            result[i - start] = this.getPadCharacter();
            ++i;
        }
        return result;
    }

    @Override
    public int getApduDataSize() {
        if (this.getBlockSize() == 0) {
            return 4;
        }
        return 5 + this.getBlockSize();
    }

    @Override
    public int getFormatFormat() {
        return 2;
    }

    @Override
    public int getFormatJustification() {
        return 0;
    }

    @Override
    public int getFormatPosition() {
        return 0;
    }

    @Override
    public int getFormatUnit() {
        return 1;
    }

    @Override
    public int getPinBlockPinLengthSize() {
        return 0;
    }

    @Override
    public int getPinLengthPosition() {
        return 0;
    }

    @Override
    public int getPinLengthUnit() {
        return 0;
    }

    @Override
    public String getType() {
        return "Ascii";
    }
}

