/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.common;

import de.intarsys.security.smartcard.common.CommonPinCodec;

public class PinCodecBcd
extends CommonPinCodec {
    public PinCodecBcd(int padCharacter, int minCharacters, int maxCharacters) {
        super((byte)(padCharacter == -1 ? 15 : (byte)padCharacter), minCharacters, maxCharacters, 0);
    }

    @Override
    public byte[] encode(char[] pin) {
        int i;
        int length;
        int i2;
        int start = pin.length;
        int end = -1;
        for (i2 = 0; i2 < pin.length; ++i2) {
            if (Character.isWhitespace(pin[i2])) continue;
            start = i2;
            break;
        }
        for (i2 = pin.length - 1; i2 >= 0; --i2) {
            if (Character.isWhitespace(pin[i2])) continue;
            end = i2;
            break;
        }
        if ((length = end - start + 1) < 0) {
            length = 0;
        }
        byte[] result = new byte[length];
        for (int i3 = start; i3 <= end; ++i3) {
            result[i3 - start] = (byte)pin[i3];
        }
        byte[] pin2Block = new byte[this.getBlockSize()];
        for (i = 0; i < result.length; ++i) {
            int p2i;
            int b = result[i] - 48;
            if (i % 2 == 0) {
                b <<= 4;
            }
            int n = p2i = i / 2;
            pin2Block[n] = (byte)(pin2Block[n] | b);
        }
        for (i = result.length; i < (pin2Block.length - 1) * 2; ++i) {
            if (i % 2 == 0) {
                int n = i / 2 + 1;
                pin2Block[n] = (byte)(pin2Block[n] | 0xF0);
                continue;
            }
            int n = i / 2 + 1;
            pin2Block[n] = (byte)(pin2Block[n] | 0xF);
        }
        return pin2Block;
    }

    @Override
    public int getApduDataSize() {
        return 13;
    }

    @Override
    public int getBlockSize() {
        return (this.getMaxCharacters() + 1) / 2;
    }

    @Override
    public int getFormatFormat() {
        return 1;
    }

    @Override
    public int getFormatJustification() {
        return 0;
    }

    @Override
    public int getFormatPosition() {
        return 0;
    }

    @Override
    public int getFormatUnit() {
        return 1;
    }

    @Override
    public int getPinBlockPinLengthSize() {
        return 4;
    }

    @Override
    public int getPinLengthPosition() {
        return 0;
    }

    @Override
    public int getPinLengthUnit() {
        return 0;
    }

    @Override
    public String getType() {
        return "BCD";
    }
}

