/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.common;

import de.intarsys.security.smartcard.common.PACKAGE;
import de.intarsys.security.smartcard.common.PinState;
import de.intarsys.security.smartcard.model.IPinInfo;
import de.intarsys.tools.message.IMessageBundle;

public class PinTools {
    private static IMessageBundle Msg = PACKAGE.Messages;

    public static String getPinRetriesLabel(IPinInfo pinInfo, PinState pinState) {
        IMessageBundle messageBundle = Msg;
        return PinTools.getPinRetriesLabel(pinState, messageBundle);
    }

    public static String getPinRetriesLabel(PinState pinState, IMessageBundle messageBundle) {
        if (messageBundle == null) {
            messageBundle = Msg;
        }
        if (pinState.getRetries() < 0) {
            return messageBundle.getString("PinState.retries.unknown", new Object[0]);
        }
        if (pinState.getRetries() == 0) {
            return messageBundle.getString("PinState.retries.none", new Object[0]);
        }
        return messageBundle.getString("PinState.retries.available", new Object[]{pinState.getRetries()});
    }

    public static String getPinStateLabel(IPinInfo pinInfo, PinState pinState, IPinInfo resttingPinInfo, PinState resettingPinState) {
        IMessageBundle messageBundle = Msg;
        return PinTools.getPinStateLabel(pinInfo, pinState, resttingPinInfo, resettingPinState, messageBundle);
    }

    public static String getPinStateLabel(IPinInfo pinInfo, PinState pinState, IPinInfo resttingPinInfo, PinState resettingPinState, IMessageBundle messageBundle) {
        if (messageBundle == null) {
            messageBundle = Msg;
        }
        String resettingQualifier = "reset-none";
        String resettingLabel = "";
        if (resttingPinInfo != null && resettingPinState != null) {
            if (resettingPinState.isVerifiable()) {
                resettingQualifier = "reset-verifiable";
            } else if (resettingPinState.isInitializable()) {
                resettingQualifier = "reset-initializable";
            }
            resettingLabel = resttingPinInfo.getLabel();
        }
        String id = pinState == null ? "unknown" : pinState.getId();
        return messageBundle.getString("PinState." + id + "." + resettingQualifier + ".label", new Object[]{pinInfo.getLabel(), resettingLabel});
    }

    private PinTools() {
    }
}

