/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.environment;

import de.intarsys.security.smartcard.card.CardSystem;
import de.intarsys.tools.component.SingletonProvider;
import de.intarsys.tools.preferences.IPreferences;
import de.intarsys.tools.preferences.IPreferencesSupport;
import de.intarsys.tools.preferences.IPreferencesSyncher;
import de.intarsys.tools.preferences.PreferencesFactory;
import de.intarsys.tools.servicelocator.ServiceLocator;
import jakarta.annotation.PostConstruct;

@SingletonProvider
public class SmartcardEnvironment
implements IPreferencesSupport,
IPreferencesSyncher {
    public static final String PREF_ENABLED = "enabled";
    public static final String PREF_ENFORCESPE = "enforceSPE";
    public static final String PREF_SIGNATURE_HASH_ALGORITHM = "signatureHashAlgorithm";
    public static final String PREF_DISABLESPE = "disableSPE";
    public static final String PREF_ENABLEPINCACHE = "enablePinCache";
    public static final String PREF_ENFORCEPINENTRY = "enforcePinEntry";
    public static final String PREF_SPETIMEOUT = "speTimeout";
    public static final String PREF_SPETIMEOUTAFTERFIRSTKEYPRESS = "speTimeoutAfterFirstKeyPress";
    public static final int DEFAULT_SPE_TIMEOUT = 30;
    public static final int DEFAULT_SPE_TIMEOUTAFTERFIRSTKEYPRESS = 10;
    private String signatureHashAlgorithm;
    private IPreferences preferences;
    private boolean enabled = true;
    private boolean enforceSPE = true;
    private boolean enforcePinEntry = true;
    private boolean disableSPE = false;
    private boolean enablePinCache = false;
    private int speTimeout = 30;
    private int speTimeoutAfterFirstKeyPress = 10;

    public static SmartcardEnvironment get() {
        return (SmartcardEnvironment)ServiceLocator.get().get(SmartcardEnvironment.class);
    }

    protected IPreferences createPreferences() {
        String name = this.getPreferencesName();
        IPreferences root = PreferencesFactory.get().getRoot();
        IPreferences result = root.node(name);
        IPreferences defaultPreferences = result.restrict("DEFAULT");
        this.preferencesInit(defaultPreferences);
        return result;
    }

    public final IPreferences getPreferences() {
        if (this.preferences == null) {
            this.preferences = this.createPreferences();
        }
        return this.preferences;
    }

    protected String getPreferencesName() {
        return "de.intarsys.prefs.security.smartcard";
    }

    public String getSignatureHashAlgorithm() {
        return this.signatureHashAlgorithm;
    }

    public int getSpeTimeout() {
        return this.speTimeout;
    }

    public int getSpeTimeoutAfterFirstKeyPress() {
        return this.speTimeoutAfterFirstKeyPress;
    }

    @PostConstruct
    public void init() {
        this.preferencesRestore();
    }

    public boolean isDisableSPE() {
        return this.disableSPE;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isEnablePinCache() {
        return this.enablePinCache;
    }

    public boolean isEnforcePinEntry() {
        return this.enforcePinEntry;
    }

    public boolean isEnforceSPE() {
        return this.enforceSPE;
    }

    protected void preferencesInit(IPreferences preferences) {
        preferences.put(PREF_ENABLED, true);
        preferences.put(PREF_ENFORCESPE, true);
        preferences.put(PREF_DISABLESPE, false);
        preferences.put(PREF_SIGNATURE_HASH_ALGORITHM, "SHA-512");
    }

    public void preferencesRestore() {
        IPreferences prefs = this.getPreferences();
        this.setEnabled(prefs.getBoolean(PREF_ENABLED, this.isEnabled()));
        this.setSignatureHashAlgorithm(prefs.get(PREF_SIGNATURE_HASH_ALGORITHM, this.getSignatureHashAlgorithm()));
        this.setSpeTimeout(prefs.getInt(PREF_SPETIMEOUT, 30));
        this.setSpeTimeoutAfterFirstKeyPress(prefs.getInt(PREF_SPETIMEOUTAFTERFIRSTKEYPRESS, 10));
        this.setDisableSPE(prefs.getBoolean(PREF_DISABLESPE, this.isDisableSPE()));
        this.setEnforceSPE(prefs.getBoolean(PREF_ENFORCESPE, !this.isDisableSPE()));
        this.setEnforcePinEntry(prefs.getBoolean(PREF_ENFORCEPINENTRY, this.isEnforceSPE()));
        this.setEnablePinCache(prefs.getBoolean(PREF_ENABLEPINCACHE, !this.isEnforceSPE()));
    }

    public void preferencesStore() {
        IPreferences tmpPreferences = this.getPreferences();
        tmpPreferences.putBoolean(PREF_ENABLED, this.isEnabled());
        tmpPreferences.putBoolean(PREF_ENFORCEPINENTRY, this.isEnforcePinEntry());
        tmpPreferences.putBoolean(PREF_ENFORCESPE, this.isEnforceSPE());
        tmpPreferences.putBoolean(PREF_DISABLESPE, this.isDisableSPE());
        tmpPreferences.putBoolean(PREF_ENABLEPINCACHE, this.isEnablePinCache());
        tmpPreferences.put(PREF_SIGNATURE_HASH_ALGORITHM, this.getSignatureHashAlgorithm());
    }

    public void setDisableSPE(boolean disableSPE) {
        this.disableSPE = disableSPE;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        CardSystem.get().setEnabled(enabled);
    }

    public void setEnablePinCache(boolean enablePinCache) {
        this.enablePinCache = enablePinCache;
    }

    public void setEnforcePinEntry(boolean enforcePinEntry) {
        this.enforcePinEntry = enforcePinEntry;
    }

    public void setEnforceSPE(boolean enforceSPE) {
        this.enforceSPE = enforceSPE;
    }

    public void setSignatureHashAlgorithm(String signatureHashAlgorithm) {
        this.signatureHashAlgorithm = signatureHashAlgorithm;
    }

    public void setSpeTimeout(int pSpeTimeout) {
        this.speTimeout = pSpeTimeout;
    }

    public void setSpeTimeoutAfterFirstKeyPress(int value) {
        this.speTimeoutAfterFirstKeyPress = value;
    }
}

