/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.explorer;

import de.intarsys.security.smartcard.explorer.BinaryHexViewer;
import de.intarsys.security.smartcard.explorer.BinarySimpleTlvViewer;
import de.intarsys.security.smartcard.explorer.BinaryViewer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class BinaryMultiViewer
extends BinaryViewer {
    private JComboBox cSelector;
    private BinaryViewer cData;
    private JPanel cSelection;

    public BinaryMultiViewer() {
        this.init();
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        this.cSelector = new JComboBox();
        this.cSelector.addItem(new BinaryHexViewer());
        this.cSelector.addItem(new BinarySimpleTlvViewer());
        this.cSelector.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    BinaryMultiViewer.this.onSelected((BinaryViewer)e.getItem());
                }
            }
        });
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.anchor = 11;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        this.add((Component)this.cSelector, gbc);
        this.cSelection = new JPanel();
        this.cSelection.setLayout(new BorderLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.add((Component)this.cSelection, gbc);
        this.updateViewData();
    }

    protected void onSelected(BinaryViewer item) {
        this.updateViewData();
    }

    @Override
    protected void updateView() {
        super.updateView();
        if (this.cData != null) {
            this.cData.setBytes(this.getBytes());
        }
        this.repaint();
    }

    protected void updateViewData() {
        BinaryViewer tempViewer = (BinaryViewer)this.cSelector.getSelectedItem();
        if (tempViewer != this.cData) {
            this.cSelection.removeAll();
            this.cData = tempViewer;
            if (this.cData != null) {
                this.cSelection.add(this.cData);
            }
            this.validate();
        }
        this.updateView();
    }
}

