/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.explorer;

import de.intarsys.security.smartcard.explorer.BinaryFormattedViewer;
import de.intarsys.security.smartcard.explorer.BinaryMultiViewer;
import de.intarsys.security.smartcard.iso.tlv.Iso7816SimpleInputStream;
import de.intarsys.tools.tlv.common.TlvElement;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.IOException;
import javax.swing.JLabel;

public class BinarySimpleTlvViewer
extends BinaryFormattedViewer {
    public BinarySimpleTlvViewer() {
        this.init();
    }

    private void init() {
        this.setLayout(new GridBagLayout());
    }

    @Override
    public String toString() {
        return "Simple TLV";
    }

    @Override
    protected void updateView() {
        super.updateView();
        this.removeAll();
        if (this.getBytes() != null) {
            try {
                Iso7816SimpleInputStream is = new Iso7816SimpleInputStream(this.getBytes(), 0, this.getBytes().length);
                TlvElement element = is.readElement();
                int row = 0;
                while (element != null) {
                    JLabel label = new JLabel();
                    label.setText(Integer.toHexString(element.getIdentifier()));
                    GridBagConstraints gbc = new GridBagConstraints();
                    gbc.gridx = 0;
                    gbc.gridy = row;
                    gbc.weightx = 0.0;
                    gbc.weighty = 1.0;
                    gbc.anchor = 11;
                    gbc.fill = 3;
                    this.add((Component)label, gbc);
                    BinaryMultiViewer viewer = new BinaryMultiViewer();
                    viewer.setBytes(element.getValue());
                    gbc = new GridBagConstraints();
                    gbc.gridx = 1;
                    gbc.gridy = row;
                    gbc.weightx = 1.0;
                    gbc.weighty = 1.0;
                    gbc.fill = 1;
                    this.add((Component)viewer, gbc);
                    element = is.readElement();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.validate();
    }
}

