/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.explorer;

import de.intarsys.security.smartcard.explorer.CardDetailPanel;
import de.intarsys.security.smartcard.explorer.CardExplorerFileSystemNode;
import de.intarsys.security.smartcard.explorer.CardExplorerNode;
import de.intarsys.security.smartcard.explorer.CardExplorerNodeFactory;
import de.intarsys.security.smartcard.explorer.CardExplorerPanelNode;
import de.intarsys.security.smartcard.explorer.CardInfoPanel;
import de.intarsys.security.smartcard.explorer.CardScriptPanel;
import de.intarsys.security.smartcard.explorer.CardletPanel;
import de.intarsys.security.smartcard.explorer.ISO7816Node;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;

public class CardExplorer
extends CardDetailPanel {
    private JTree cAspects;
    private JPanel cAspect;
    private CardDetailPanel currentDetailPanel;
    private CardExplorerNode root;

    public CardExplorer() {
        this.init();
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        this.cAspects = new JTree();
        this.cAspects.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                CardExplorer.this.onSelected((CardExplorerNode)e.getPath().getLastPathComponent());
            }
        });
        JScrollPane scroller = new JScrollPane(this.cAspects);
        this.cAspect = new JPanel();
        this.cAspect.setLayout(new BorderLayout());
        JSplitPane splitPane = new JSplitPane(1, scroller, this.cAspect);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)splitPane, gbc);
        splitPane.setOneTouchExpandable(true);
        splitPane.setDividerLocation(150);
        Dimension minimumSize = new Dimension(100, 50);
        this.cAspects.setMinimumSize(minimumSize);
        this.cAspect.setMinimumSize(minimumSize);
        this.updateTree();
    }

    protected void onSelected(CardExplorerNode node) {
        if (this.currentDetailPanel != null) {
            this.currentDetailPanel.eventHide();
        }
        this.cAspect.removeAll();
        this.currentDetailPanel = node.getPanel();
        if (this.currentDetailPanel != null) {
            this.cAspect.add((Component)this.currentDetailPanel, "Center");
            this.currentDetailPanel.eventShow();
        }
        this.cAspect.repaint();
        this.cAspect.validate();
    }

    protected void updateTree() {
        this.root = new CardExplorerNode(this, this.getCardConnection());
        if (this.getCardConnection() != null) {
            this.root.add(new ISO7816Node(this, this.getCardConnection())).add(new CardExplorerPanelNode(this, this.getCardConnection(), new CardInfoPanel())).add(new CardExplorerPanelNode(this, this.getCardConnection(), new CardletPanel())).add(new CardExplorerPanelNode(this, this.getCardConnection(), new CardScriptPanel())).add(new CardExplorerFileSystemNode(this, this.getCardConnection()));
            for (CardExplorerNodeFactory factory : CardExplorerNode.getFactories()) {
                CardExplorerNode node = factory.createCardExplorerNode(this, this.getCardConnection());
                if (node == null) continue;
                this.root.add(node);
            }
        }
        DefaultTreeModel model = new DefaultTreeModel(this.root);
        this.cAspects.setModel(model);
        this.cAspects.setRootVisible(false);
        this.cAspects.setShowsRootHandles(true);
    }

    @Override
    protected void updateView() {
        super.updateView();
        this.updateTree();
        this.onSelected(this.root);
    }
}

