/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.explorer;

import de.intarsys.security.smartcard.card.ICardConnection;
import de.intarsys.security.smartcard.explorer.CardExplorer;
import de.intarsys.security.smartcard.explorer.CardExplorerPanelNode;
import de.intarsys.security.smartcard.explorer.CardFilePanel;
import de.intarsys.security.smartcard.model.CiCardProduct;
import de.intarsys.security.smartcard.model.ICardFile;
import de.intarsys.security.smartcard.model.ICardFileSystem;
import de.intarsys.security.smartcard.model.ICardProduct;

public class CardExplorerFileSystemNode
extends CardExplorerPanelNode {
    private final ICardFile file;

    public CardExplorerFileSystemNode(CardExplorer explorer, ICardConnection cardConnection) {
        super(explorer, cardConnection, new CardFilePanel());
        this.file = this.getRoot();
    }

    public CardExplorerFileSystemNode(CardExplorer explorer, ICardConnection cardConnection, ICardFile file) {
        super(explorer, cardConnection, new CardFilePanel());
        this.file = file;
        if (file != null) {
            ((CardFilePanel)this.getPanel()).setSelector(file.asSelector());
        }
    }

    @Override
    protected void basicCreateChildren() {
        super.basicCreateChildren();
        if (this.getFile() == null) {
            return;
        }
        for (ICardFile child : this.getFile().getFiles()) {
            CardExplorerFileSystemNode childNode = new CardExplorerFileSystemNode(this.getExplorer(), this.getCardConnection(), child);
            this.add(childNode);
        }
    }

    public ICardFile getFile() {
        return this.file;
    }

    @Override
    protected String getLabelDefault() {
        if (this.file != null) {
            return this.file.getLabel();
        }
        return super.getLabelDefault();
    }

    protected ICardFile getRoot() {
        ICardFileSystem ciFileSystem;
        ICardProduct product = this.getExplorer().getCardProduct();
        if (product instanceof CiCardProduct && (ciFileSystem = product.getCardInfo().getFileSystem()) != null) {
            ICardFile ciRoot = ciFileSystem.lookupFile("MF");
            return ciRoot;
        }
        return null;
    }
}

