/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.explorer;

import de.intarsys.security.smartcard.card.ICardConnection;
import de.intarsys.security.smartcard.explorer.CardDetailPanel;
import de.intarsys.security.smartcard.explorer.CardExplorer;
import de.intarsys.security.smartcard.explorer.CardExplorerNodeFactory;
import de.intarsys.security.smartcard.model.CardProductTools;
import de.intarsys.security.smartcard.model.CiCardProductFactory;
import de.intarsys.security.smartcard.model.ICardProduct;
import de.intarsys.security.smartcard.model.ICardProductFactory;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.TreeNode;

public class CardExplorerNode
implements TreeNode {
    private static final List<CardExplorerNodeFactory> factories = new ArrayList<CardExplorerNodeFactory>();
    private final CardExplorer explorer;
    private final ICardConnection cardConnection;
    private String label;
    private CardExplorerNode parent;
    private String iconName;
    private boolean created = false;
    private List<CardExplorerNode> children = new ArrayList<CardExplorerNode>();

    public static List<CardExplorerNodeFactory> getFactories() {
        return factories;
    }

    public static ICardProductFactory getGenericFactory() {
        CiCardProductFactory factory = new CiCardProductFactory();
        factory.setCardInfoFile("/de/intarsys/security/smartcard/product/generic/v10/card.xml");
        return factory;
    }

    public static void registerFactory(CardExplorerNodeFactory factory) {
        factories.add(factory);
    }

    public CardExplorerNode(CardExplorer explorer, ICardConnection cardConnection) {
        this.explorer = explorer;
        this.cardConnection = cardConnection;
    }

    public CardExplorerNode add(CardExplorerNode node) {
        node.setParent(this);
        this.children.add(node);
        this.created = true;
        return this;
    }

    protected void basicCreateChildren() {
    }

    public Enumeration children() {
        this.createChildren();
        return Collections.enumeration(this.children);
    }

    protected void createChildren() {
        if (this.created) {
            return;
        }
        this.created = true;
        this.basicCreateChildren();
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    public ICardConnection getCardConnection() {
        return this.cardConnection;
    }

    protected ICardProduct getCardProduct() {
        if (this.getCardConnection() == null) {
            return null;
        }
        try {
            return CardProductTools.getCardProduct(this.getCardConnection());
        }
        catch (Exception exception) {
            try {
                ICardProductFactory factory = CardExplorerNode.getGenericFactory();
                return factory.create(this.getCardConnection());
            }
            catch (CardApplicationException e) {
                return null;
            }
        }
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        this.createChildren();
        return this.children.get(childIndex);
    }

    @Override
    public int getChildCount() {
        this.createChildren();
        return this.children.size();
    }

    public CardExplorer getExplorer() {
        return this.explorer;
    }

    public String getIconName() {
        return this.iconName;
    }

    @Override
    public int getIndex(TreeNode node) {
        this.createChildren();
        return this.children.indexOf(node);
    }

    public String getLabel() {
        if (this.label == null) {
            return this.getLabelDefault();
        }
        return this.label;
    }

    protected String getLabelDefault() {
        return null;
    }

    public CardDetailPanel getPanel() {
        return null;
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    public void refresh() {
        this.created = false;
        for (CardExplorerNode node : this.children) {
            node.refresh();
        }
    }

    public CardExplorerNode setIconName(String iconName) {
        this.iconName = iconName;
        return this;
    }

    public CardExplorerNode setLabel(String label) {
        this.label = label;
        return this;
    }

    public CardExplorerNode setParent(CardExplorerNode parent) {
        this.parent = parent;
        return this;
    }

    public String toString() {
        return this.getLabel();
    }
}

