/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.explorer;

import de.intarsys.security.smartcard.app.filesystem.CardFileInfo;
import de.intarsys.security.smartcard.app.filesystem.CardFileSelector;
import de.intarsys.security.smartcard.app.filesystem.IFileSystemApplication;
import de.intarsys.security.smartcard.card.ICardConnection;
import de.intarsys.security.smartcard.model.CardProductTools;
import de.intarsys.security.smartcard.model.ICardProduct;
import de.intarsys.security.smartcard.model.app.CardApplicationException;

public class CardFileContent {
    private final CardFileSelector selector;
    private CardFileInfo info;
    private byte[][] records;
    private Exception exception;

    public CardFileContent(ICardConnection connection, CardFileSelector selector) {
        this.selector = selector;
        this.read(connection);
    }

    public Exception getException() {
        return this.exception;
    }

    public CardFileInfo getInfo() {
        return this.info;
    }

    public byte[][] getRecords() {
        return this.records;
    }

    public CardFileSelector getSelector() {
        return this.selector;
    }

    protected void read(ICardConnection connection) {
        try {
            ICardProduct product = CardProductTools.getCardProduct(connection);
            IFileSystemApplication fs = product.createCardApplication(connection, IFileSystemApplication.class);
            this.info = fs.selectEf(this.getSelector(), true);
            this.records = this.info.isTransparent() ? (Object)new byte[][]{fs.readBinary(this.getSelector())} : fs.readRecords(this.getSelector(), -1);
        }
        catch (Exception e) {
            this.exception = e;
        }
    }

    public void setException(CardApplicationException exception) {
        this.exception = exception;
    }
}

