/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.explorer;

import de.intarsys.security.smartcard.app.filesystem.CardFileSelector;
import de.intarsys.security.smartcard.explorer.BinaryMultiViewer;
import de.intarsys.security.smartcard.explorer.BinaryViewer;
import de.intarsys.security.smartcard.explorer.CardDetailPanel;
import de.intarsys.security.smartcard.explorer.CardFileContent;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class CardFilePanel
extends CardDetailPanel {
    private JButton cNext;
    private JButton cPrev;
    private JLabel cRecordNo;
    private JLabel cMessage;
    private CardFileSelector selector;
    private JPanel cRecordControl;
    private int recordIndex;
    private CardFileContent content;
    private BinaryViewer cViewer;

    public CardFilePanel() {
        this.init();
    }

    @Override
    public void eventShow() {
        super.eventShow();
        if (this.getCardConnection() == null || this.getSelector() == null) {
            this.cViewer.setBytes(null);
            return;
        }
        this.recordIndex = 0;
        this.content = new CardFileContent(this.getCardConnection(), this.getSelector());
        this.updateViewRecord();
    }

    protected JButton getcNext() {
        return this.cNext;
    }

    protected JButton getcPrev() {
        return this.cPrev;
    }

    public CardFileSelector getSelector() {
        return this.selector;
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        this.cRecordControl = new JPanel();
        this.cRecordControl.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        this.add((Component)this.cRecordControl, gbc);
        this.cPrev = new JButton("<");
        this.cPrev.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CardFilePanel.this.onPrev();
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 0;
        this.cRecordControl.add((Component)this.cPrev, gbc);
        this.cRecordNo = new JLabel();
        gbc = new GridBagConstraints();
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 0;
        this.cRecordControl.add((Component)this.cRecordNo, gbc);
        this.cNext = new JButton(">");
        this.cNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CardFilePanel.this.onNext();
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 0;
        this.cRecordControl.add((Component)this.cNext, gbc);
        this.cMessage = new JLabel();
        gbc = new GridBagConstraints();
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        this.cRecordControl.add((Component)this.cMessage, gbc);
        this.cViewer = new BinaryMultiViewer();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        this.add((Component)this.cViewer, gbc);
    }

    protected void onNext() {
        ++this.recordIndex;
        this.updateViewRecord();
    }

    protected void onPrev() {
        --this.recordIndex;
        this.updateViewRecord();
    }

    public void setSelector(CardFileSelector selector) {
        this.selector = selector;
    }

    protected void updateViewRecord() {
        if (this.content.getException() == null) {
            if (this.content.getInfo().isTransparent()) {
                byte[] rec = this.content.getRecords()[0];
                this.cViewer.setBytes(rec);
                this.cRecordControl.setVisible(false);
            } else {
                if (this.recordIndex < 0) {
                    this.recordIndex = 0;
                }
                if (this.recordIndex >= this.content.getRecords().length) {
                    this.recordIndex = this.content.getRecords().length - 1;
                }
                byte[] rec = this.content.getRecords()[this.recordIndex];
                this.cViewer.setBytes(rec);
                this.cRecordNo.setText("" + this.recordIndex);
                this.cRecordControl.setVisible(true);
            }
        } else {
            this.cRecordControl.setVisible(true);
            this.cMessage.setText(this.content.getException().getLocalizedMessage());
        }
    }
}

