/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.explorer;

import de.intarsys.security.smartcard.explorer.CardDetailPanel;
import de.intarsys.security.smartcard.model.CardProductTools;
import de.intarsys.security.smartcard.model.CiCardProduct;
import de.intarsys.security.smartcard.model.ICardProduct;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.tools.stream.StreamTools;
import java.awt.BorderLayout;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class CardInfoPanel
extends CardDetailPanel {
    private JTextArea cText;

    public CardInfoPanel() {
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void eventShow() {
        String text;
        block10: {
            super.eventShow();
            if (this.getCardConnection() == null) {
                text = "no card";
            } else {
                try {
                    ICardProduct product = CardProductTools.getCardProduct(this.getCardConnection());
                    if (product instanceof CiCardProduct) {
                        String filename = ((CiCardProduct)product).getFactory().getCardInfoFile();
                        InputStream is = null;
                        try {
                            is = CiCardProduct.class.getResourceAsStream(filename);
                            text = StreamTools.getString((InputStream)is, (Charset)StandardCharsets.UTF_8);
                            break block10;
                        }
                        catch (IOException e) {
                            text = "error reading card info";
                            break block10;
                        }
                        finally {
                            StreamTools.close((Closeable)is);
                        }
                    }
                    text = "no card info available";
                }
                catch (CardApplicationException e) {
                    text = "unknown card product";
                }
            }
        }
        this.cText.setText(text);
    }

    @Override
    public String getLabel() {
        return "Card Info";
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.cText = new JTextArea();
        JScrollPane cScroller = new JScrollPane(this.cText);
        this.add(cScroller);
    }
}

