/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.explorer;

import de.intarsys.security.smartcard.card.ActiveCardConnectionMonitor;
import de.intarsys.security.smartcard.card.CardSystem;
import de.intarsys.security.smartcard.card.ICardConnection;
import de.intarsys.security.smartcard.card.ICardSystem;
import de.intarsys.security.smartcard.card.ICardTerminal;
import de.intarsys.tools.event.AttributeChangedEvent;
import de.intarsys.tools.event.Event;
import de.intarsys.tools.event.EventDispatcher;
import de.intarsys.tools.event.EventType;
import de.intarsys.tools.event.INotificationListener;
import de.intarsys.tools.presentation.PresentationAdapter;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class CardSelector
extends JPanel {
    private ActiveCardConnectionMonitor cardConnectionMonitor;
    private JComboBox cardTerminalCombo;
    private final ActionListener listenTerminalSelection = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            CardSelector.this.onCardTerminalSelected(e);
        }
    };
    private final EventDispatcher dispatcher = new EventDispatcher((Object)this);
    private boolean updateView = false;

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.add(new CardSelector());
        frame.setSize(300, 300);
        frame.pack();
        frame.setVisible(true);
    }

    public CardSelector() {
        this.init();
    }

    public void actionPerformed(ActionEvent e) {
        this.listenTerminalSelection.actionPerformed(e);
    }

    public void addNotificationListener(EventType type, INotificationListener listener) {
        this.dispatcher.addNotificationListener(type, listener);
    }

    private void init() {
        this.cardTerminalCombo = new JComboBox();
        this.cardTerminalCombo.addActionListener(this.listenTerminalSelection);
        this.add(this.cardTerminalCombo);
        this.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 4L) != 0L) {
                    if (CardSelector.this.isShowing()) {
                        CardSelector.this.start();
                    } else {
                        CardSelector.this.stop();
                    }
                }
            }
        });
    }

    protected void onCardTerminalSelected(ActionEvent e) {
        if (this.updateView) {
            return;
        }
        PresentationAdapter pa = (PresentationAdapter)this.cardTerminalCombo.getSelectedItem();
        ICardTerminal cardTerminal = (ICardTerminal)pa.getObject();
        this.cardConnectionMonitor.setActiveCardTerminal(cardTerminal);
    }

    public void removeNotificationListener(EventType type, INotificationListener listener) {
        this.dispatcher.removeNotificationListener(type, listener);
    }

    protected void start() {
        ICardSystem cardSystem = CardSystem.get();
        this.cardConnectionMonitor = new ActiveCardConnectionMonitor(cardSystem);
        this.cardConnectionMonitor.addNotificationListener(AttributeChangedEvent.ID, new INotificationListener(){

            public void handleEvent(final Event event) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ActiveCardConnectionMonitor.State state = (ActiveCardConnectionMonitor.State)((AttributeChangedEvent)event).getNewValue();
                        CardSelector.this.updateView(state);
                        ICardConnection connection = state.getActiveCardConnection();
                        CardSelector.this.triggerEvent((Event)new AttributeChangedEvent((Object)this, (Object)"connection", null, (Object)connection));
                    }
                });
            }
        });
        this.cardConnectionMonitor.start();
        this.updateView(this.cardConnectionMonitor.getState());
    }

    protected void stop() {
        if (this.cardConnectionMonitor != null) {
            this.cardConnectionMonitor.dispose();
        }
    }

    protected void triggerEvent(Event event) {
        this.dispatcher.triggerEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateView(ActiveCardConnectionMonitor.State state) {
        if (this.updateView) {
            return;
        }
        try {
            this.updateView = true;
            Collections.sort(state.getCardTerminals(), new Comparator<ICardTerminal>(){

                @Override
                public int compare(ICardTerminal o1, ICardTerminal o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            this.cardTerminalCombo.removeAllItems();
            for (int i = 0; i < state.getCardTerminals().size(); ++i) {
                ICardTerminal terminal = (ICardTerminal)state.getCardTerminals().get(i);
                this.cardTerminalCombo.addItem(new PresentationAdapter((Object)terminal, terminal.getName()));
            }
            this.cardTerminalCombo.setSelectedItem(state.getActiveCardTerminal());
        }
        finally {
            this.updateView = false;
        }
    }
}

