/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.smartcard.explorer;

import de.intarsys.security.smartcard.card.ICardConnection;
import de.intarsys.security.smartcard.explorer.CardExplorer;
import de.intarsys.security.smartcard.explorer.CardSelector;
import de.intarsys.tools.event.AttributeChangedEvent;
import de.intarsys.tools.event.Event;
import de.intarsys.tools.event.INotificationListener;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class CardSystemExplorer
extends JPanel {
    private CardSelector cSelector;
    private CardExplorer cExplorer;

    public static void main(String[] args) {
        CardSystemExplorer.open();
    }

    public static void open() {
        JFrame frame = new JFrame();
        frame.add(new CardSystemExplorer());
        frame.setSize(800, 600);
        frame.setVisible(true);
    }

    public CardSystemExplorer() {
        this.init();
    }

    protected CardSelector getcSelector() {
        return this.cSelector;
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        this.cSelector = new CardSelector();
        this.cSelector.addNotificationListener(AttributeChangedEvent.ID, new INotificationListener(){

            public void handleEvent(Event event) {
                ICardConnection connection = (ICardConnection)((AttributeChangedEvent)event).getNewValue();
                CardSystemExplorer.this.onCardConnectionChange(connection);
            }
        });
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        this.add((Component)this.cSelector, gbc);
        this.cExplorer = new CardExplorer();
        gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.add((Component)this.cExplorer, gbc);
    }

    protected void onCardConnectionChange(ICardConnection card) {
        this.cExplorer.setCardConnection(card);
    }
}

